/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.external.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.dashbuilder.external.service.ComponentAssetProvider;
import org.dashbuilder.external.service.ComponentLoader;

@ApplicationScoped
public class ComponentAssetProviderImpl
implements ComponentAssetProvider {
    @Inject
    ComponentLoader componentsLoader;

    public InputStream openAsset(String componentAssetPath) {
        String normalizedAssetPath;
        if (componentAssetPath != null && (normalizedAssetPath = FilenameUtils.normalizeNoEndSeparator((String)componentAssetPath)) != null) {
            return this.getInternalComponentAsset(normalizedAssetPath).orElseGet(() -> this.getExternalComponentAsset(normalizedAssetPath));
        }
        throw new IllegalArgumentException("Invalid Asset Path.");
    }

    String fixSlashes(String componentAssetPath) {
        return componentAssetPath == null ? "" : componentAssetPath.replaceAll("\\\\", "/");
    }

    private Optional<InputStream> getInternalComponentAsset(String componentAssetPath) {
        String internalComponentsBaseDir = this.componentsLoader.getProvidedComponentsPath();
        String fullPath = "/" + internalComponentsBaseDir + "/" + this.fixSlashes(componentAssetPath);
        return Optional.ofNullable(this.getClass().getResourceAsStream(fullPath));
    }

    private InputStream getExternalComponentAsset(String componentAssetPath) {
        Path assetPath;
        if (!this.componentsLoader.isExternalComponentsEnabled()) {
            throw new IllegalArgumentException("External Components are not enabled");
        }
        Path baseDir = Paths.get(this.componentsLoader.getExternalComponentsDir(), new String[0]);
        if (this.isFileInComponentsDir(baseDir, assetPath = baseDir.resolve(componentAssetPath))) {
            return this.loadExternalComponentFile(assetPath);
        }
        throw new IllegalArgumentException("Not a component file.");
    }

    private InputStream loadExternalComponentFile(Path assetPath) {
        try {
            return new FileInputStream(assetPath.toFile());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Error opening component file: " + e.getMessage(), e);
        }
    }

    private boolean isFileInComponentsDir(Path baseDir, Path assetPath) {
        return assetPath.toAbsolutePath().normalize().startsWith(baseDir);
    }
}

