/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.external.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dashbuilder.external.impl.ComponentServiceImpl;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.external.service.ComponentLoader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ComponentServiceImplTest {
    private static final String C1_ID = "c1";
    private static final String C2_ID = "c2";
    @Mock
    ComponentLoader loader;
    @InjectMocks
    ComponentServiceImpl externalComponentServiceImpl;

    @Test
    public void testById() {
        ExternalComponent c1 = new ExternalComponent(C1_ID, "c1 name", "c1 icon", false, Collections.emptyList());
        ExternalComponent c2 = new ExternalComponent(C2_ID, "c2 name", "c2 icon", false, Collections.emptyList());
        Mockito.when((Object)this.loader.loadExternal()).thenReturn(Arrays.asList(c1, c2));
        Assert.assertTrue((boolean)this.externalComponentServiceImpl.byId(C1_ID).isPresent());
        Assert.assertTrue((boolean)this.externalComponentServiceImpl.byId(C2_ID).isPresent());
        Assert.assertFalse((boolean)this.externalComponentServiceImpl.byId("do not exist").isPresent());
    }

    @Test
    public void testByIdProvidedPriority() {
        String c1ProvidedName = "c1 provided";
        ExternalComponent c1_provided = new ExternalComponent(C1_ID, c1ProvidedName, "c1 icon", false, Collections.emptyList());
        ExternalComponent c1_external = new ExternalComponent(C1_ID, "c1 external", "c1 icon", false, Collections.emptyList());
        Mockito.when((Object)this.loader.loadProvided()).thenReturn(Arrays.asList(c1_provided));
        Mockito.when((Object)this.loader.loadExternal()).thenReturn(Arrays.asList(c1_external));
        Assert.assertEquals((Object)c1ProvidedName, (Object)((ExternalComponent)this.externalComponentServiceImpl.byId(C1_ID).get()).getName());
    }

    @Test
    public void testListAllComponents() {
        String providedId = C1_ID;
        String externalId = C2_ID;
        ExternalComponent c1_provided = new ExternalComponent(providedId, "name", "icon", false, Collections.emptyList());
        ExternalComponent c1_external = new ExternalComponent(externalId, "name", "icon", false, Collections.emptyList());
        Mockito.when((Object)this.loader.loadProvided()).thenReturn(Arrays.asList(c1_provided));
        Mockito.when((Object)this.loader.loadExternal()).thenReturn(Arrays.asList(c1_external));
        List comps = this.externalComponentServiceImpl.listAllComponents();
        ExternalComponent cp = comps.stream().filter(c -> providedId.equals(c.getId())).findAny().get();
        ExternalComponent ce = comps.stream().filter(c -> externalId.equals(c.getId())).findAny().get();
        Assert.assertTrue((boolean)cp.isProvided());
        Assert.assertFalse((boolean)ce.isProvided());
    }
}

