/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.external;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.external.service.ComponentAssetProvider;
import org.dashbuilder.external.service.ComponentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalComponentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CACHE_CONTROL_PARAM = "cache-control";
    private static final Logger logger = LoggerFactory.getLogger(ExternalComponentServlet.class);
    @Inject
    ComponentAssetProvider assetProvider;
    @Inject
    ComponentLoader loader;
    String cacheControlHeaderValue = "no-cache";
    private MimetypesFileTypeMap mimeTypes;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mimeTypes = new MimetypesFileTypeMap();
        String cacheControl = config.getInitParameter(CACHE_CONTROL_PARAM);
        if (cacheControl != null) {
            this.cacheControlHeaderValue = cacheControl;
        }
        this.addAdditionalMimeTypes();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.handle(req, resp);
        }
        catch (IOException e) {
            logger.error("Error handling request to retrieve asset.");
            logger.debug("Error handling request to retrieve asset.", (Throwable)e);
            this.errorResponse(resp);
        }
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.reset();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            this.badRequest(resp);
            return;
        }
        String[] pathParts = pathInfo.split("/");
        if (pathParts.length < 3) {
            this.badRequest(resp);
            return;
        }
        String assetPath = Arrays.stream(pathParts).skip(1L).collect(Collectors.joining(File.separator));
        logger.debug("Retrieving component asset {}", (Object)assetPath);
        try (InputStream assetStream = this.assetProvider.openAsset(assetPath);){
            int size = IOUtils.copy((InputStream)assetStream, (OutputStream)resp.getOutputStream());
            String mimeType = this.mimeTypes.getContentType(pathInfo);
            resp.setContentType(mimeType);
            resp.setContentLength(size);
            resp.setHeader(CACHE_CONTROL_PARAM, this.cacheControlHeaderValue);
        }
        catch (Exception e) {
            logger.info("Not able to find component asset {}", (Object)assetPath);
            logger.debug("Error opening external component asset", (Throwable)e);
            resp.sendError(404);
        }
    }

    private void badRequest(HttpServletResponse resp) throws IOException {
        resp.sendError(400);
    }

    private void errorResponse(HttpServletResponse resp) {
        try {
            resp.sendError(500);
        }
        catch (IOException e) {
            logger.error("Error setting \"internal server error\" response.");
            logger.debug("Error setting \"internal server error\" response.", (Throwable)e);
        }
    }

    private void addAdditionalMimeTypes() {
        this.mimeTypes.addMimeTypes("text/javascript js");
        this.mimeTypes.addMimeTypes("text/css css");
    }
}

