/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.external.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.components.internal.ProvidedComponentInfo;
import org.dashbuilder.external.impl.ComponentAssetProviderImpl;
import org.dashbuilder.external.service.ComponentLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ComponentAssetProviderImplTest {
    @Mock
    ComponentLoader componentLoader;
    @InjectMocks
    ComponentAssetProviderImpl componentAssetProviderImpl;
    private Path componentsDir;

    @Before
    public void prepare() throws IOException {
        this.componentsDir = Files.createTempDirectory("components", new FileAttribute[0]);
        Mockito.when((Object)this.componentLoader.getExternalComponentsDir()).thenReturn((Object)this.componentsDir.toString());
        Mockito.when((Object)this.componentLoader.getProvidedComponentsPath()).thenReturn((Object)ProvidedComponentInfo.get().getInternalComponentsRootPath());
    }

    @After
    public void after() {
        FileUtils.deleteQuietly((File)this.componentsDir.toFile());
    }

    @Test
    public void testExternalComponentAsset() throws Exception {
        String componentFileContent = "abc";
        String componentId = "c1";
        String componentFileName = "testFile";
        String assetPath = this.createComponentFile(componentId, componentFileName, componentFileContent);
        Mockito.when((Object)this.componentLoader.isExternalComponentsEnabled()).thenReturn((Object)true);
        String assetFileLoadedContent = IOUtils.toString((InputStream)this.componentAssetProviderImpl.openAsset(assetPath), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)componentFileContent, (Object)assetFileLoadedContent);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExternalComponentAssetWithExternalComponentsDisabled() throws Exception {
        String componentFileContent = "abc";
        String componentId = "c1";
        String componentFileName = "testFile";
        String assetPath = this.createComponentFile(componentId, componentFileName, componentFileContent);
        Mockito.when((Object)this.componentLoader.isExternalComponentsEnabled()).thenReturn((Object)false);
        this.componentAssetProviderImpl.openAsset(assetPath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAvoidTraversalPath() throws Exception {
        String componentFileContent = "abc";
        String componentId = "c1";
        String componentFileName = "testFile";
        this.createComponentFile(componentId, componentFileName, componentFileContent);
        Path shouldNotBeAccessible = Files.createTempFile("should_not_be_accessible", "", new FileAttribute[0]);
        Path relativePath = this.componentsDir.relativize(shouldNotBeAccessible);
        Mockito.when((Object)this.componentLoader.isExternalComponentsEnabled()).thenReturn((Object)true);
        try {
            this.componentAssetProviderImpl.openAsset(relativePath.toString());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            FileUtils.deleteQuietly((File)shouldNotBeAccessible.toFile());
        }
    }

    @Test
    public void testInternalComponentAsset() throws Exception {
        String logoImage = "logo-provided/images/dashbuilder-logo.png";
        String logoIndexJs = "logo-provided/index.js";
        String logoIndexHtml = "logo-provided/index.html";
        Assert.assertNotNull((Object)this.componentAssetProviderImpl.openAsset(logoImage));
        Assert.assertNotNull((Object)this.componentAssetProviderImpl.openAsset(logoIndexJs));
        Assert.assertNotNull((Object)this.componentAssetProviderImpl.openAsset(logoIndexHtml));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInternalComponentAssetPathTraversal() throws Exception {
        Assert.assertNotNull((Object)this.componentAssetProviderImpl.openAsset("../../../dashbuilder-components.properties"));
    }

    @Test
    public void testFixSlashes() throws Exception {
        Assert.assertEquals((Object)"/abc/cde", (Object)this.componentAssetProviderImpl.fixSlashes("\\abc\\cde"));
        Assert.assertEquals((Object)"/abc/cde", (Object)this.componentAssetProviderImpl.fixSlashes("/abc/cde"));
        Assert.assertEquals((Object)"", (Object)this.componentAssetProviderImpl.fixSlashes(null));
    }

    private String createComponentFile(String componentId, String fileName, String fileContent) throws Exception {
        Path componentDir = this.componentsDir.resolve(componentId);
        Path componentFile = componentDir.resolve(fileName);
        if (!componentDir.toFile().exists()) {
            Files.createDirectory(componentDir, new FileAttribute[0]);
        }
        Files.createFile(componentFile, new FileAttribute[0]);
        Files.write(componentFile, fileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return componentId + "/" + fileName;
    }
}

