/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.kieserver.backend;

import java.util.Arrays;
import java.util.List;
import org.dashbuilder.kieserver.KieServerConnectionInfo;
import org.dashbuilder.kieserver.RemoteDataSetDef;
import org.dashbuilder.kieserver.backend.KieServerConnectionInfoProviderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KieServerConnectionInfoProviderImplTest {
    private static final String SERVER_USER = "serveruser";
    private static final String SERVER_PASSWORD = "serverpassword";
    private static final String SERVER_TOKEN = "servertoken";
    private static final String SERVER_LOCATION = "serverlocation";
    private static final String DS_USER = "dsuser";
    private static final String DS_PASSWORD = "dspassword";
    private static final String DS_TOKEN = "dstoken";
    private static final String DS_LOCATION = "dslocation";
    private KieServerConnectionInfoProviderImpl kieServerConnectionInfoProvider;
    private static final String SERVER_ID = "server1";
    private static final String DATASET_NAME = "ds1";
    private static final String SERVER_TEMPLATE_PROP = "org.dashbuilder.kieserver.serverTemplate.server1.";
    private static final String DATASET_PROP = "org.dashbuilder.kieserver.dataset.ds1.";
    private RemoteDataSetDef def;

    @Before
    public void init() {
        this.kieServerConnectionInfoProvider = new KieServerConnectionInfoProviderImpl();
        this.def = new RemoteDataSetDef();
        this.def.setName(DATASET_NAME);
        this.def.setServerTemplateId(SERVER_ID);
        this.clearProperties();
    }

    @Test
    public void serverListTest() {
        System.setProperty("org.dashbuilder.kieserver.serverTemplates", "server1, server2, server3");
        List serverTemplates = this.kieServerConnectionInfoProvider.serverTemplates();
        Assert.assertEquals((long)3L, (long)serverTemplates.size());
        List<String> expectedList = Arrays.asList(SERVER_ID, "server2", "server3");
        Assert.assertEquals(expectedList, (Object)serverTemplates);
    }

    @Test
    public void emptyServerListTest() {
        System.setProperty("org.dashbuilder.kieserver.serverTemplates", "");
        List serverTemplates = this.kieServerConnectionInfoProvider.serverTemplates();
        Assert.assertTrue((boolean)serverTemplates.isEmpty());
    }

    @Test(expected=RuntimeException.class)
    public void absentConfigurationErrorTest() {
        this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
    }

    @Test(expected=RuntimeException.class)
    public void testServerMissingAuth() {
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, "somelocation");
        this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
    }

    @Test(expected=RuntimeException.class)
    public void testDataSetMissingAuth() {
        this.setDataSetProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, "somelocation");
        this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
    }

    @Test
    public void testDsPropsPrecedence() {
        this.setDataSetProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, DS_LOCATION);
        this.setDataSetProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.USER, DS_USER);
        this.setDataSetProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.PASSWORD, DS_PASSWORD);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, SERVER_LOCATION);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.USER, SERVER_USER);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.PASSWORD, SERVER_PASSWORD);
        KieServerConnectionInfo connectionInfo = this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
        Assert.assertEquals((Object)DS_LOCATION, connectionInfo.getLocation().get());
        Assert.assertEquals((Object)DS_USER, connectionInfo.getUser().get());
        Assert.assertEquals((Object)DS_PASSWORD, connectionInfo.getPassword().get());
        Assert.assertFalse((boolean)connectionInfo.isReplaceQuery());
    }

    @Test
    public void testServerTemplateProps() {
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, SERVER_LOCATION);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.USER, SERVER_USER);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.PASSWORD, SERVER_PASSWORD);
        KieServerConnectionInfo connectionInfo = this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
        Assert.assertEquals((Object)SERVER_LOCATION, connectionInfo.getLocation().get());
        Assert.assertEquals((Object)SERVER_USER, connectionInfo.getUser().get());
        Assert.assertEquals((Object)SERVER_PASSWORD, connectionInfo.getPassword().get());
        Assert.assertFalse((boolean)connectionInfo.isReplaceQuery());
    }

    @Test
    public void testDsTokenPropPrecedence() {
        this.setDataSetProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, DS_LOCATION);
        this.setDataSetProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.TOKEN, DS_TOKEN);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, SERVER_LOCATION);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.TOKEN, SERVER_TOKEN);
        KieServerConnectionInfo connectionInfo = this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
        Assert.assertEquals((Object)DS_LOCATION, connectionInfo.getLocation().get());
        Assert.assertEquals((Object)DS_TOKEN, connectionInfo.getToken().get());
    }

    @Test
    public void testServerToken() {
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, SERVER_LOCATION);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.TOKEN, SERVER_TOKEN);
        KieServerConnectionInfo connectionInfo = this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
        Assert.assertEquals((Object)SERVER_LOCATION, connectionInfo.getLocation().get());
        Assert.assertEquals((Object)SERVER_TOKEN, connectionInfo.getToken().get());
    }

    @Test
    public void testReplaceQuery() {
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, SERVER_LOCATION);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.USER, SERVER_USER);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.PASSWORD, SERVER_PASSWORD);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.REPLACE_QUERY, "True");
        KieServerConnectionInfo connectionInfo = this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
        Assert.assertTrue((boolean)connectionInfo.isReplaceQuery());
    }

    @Test
    public void testReplaceQueryFalse() {
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.LOCATION, SERVER_LOCATION);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.USER, SERVER_USER);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.PASSWORD, SERVER_PASSWORD);
        this.setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.REPLACE_QUERY, "false");
        KieServerConnectionInfo connectionInfo = this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.def);
        Assert.assertFalse((boolean)connectionInfo.isReplaceQuery());
    }

    private void setDataSetProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey key, String value) {
        System.setProperty(DATASET_PROP + key.getValue(), value);
    }

    private void setServerProp(KieServerConnectionInfoProviderImpl.KieServerConfigurationKey key, String value) {
        System.setProperty(SERVER_TEMPLATE_PROP + key.getValue(), value);
    }

    private void clearProperties() {
        System.setProperty("org.dashbuilder.kieserver.serverTemplates", "");
        for (KieServerConnectionInfoProviderImpl.KieServerConfigurationKey key : KieServerConnectionInfoProviderImpl.KieServerConfigurationKey.values()) {
            System.setProperty(DATASET_PROP + key.getValue(), "");
            System.setProperty(SERVER_TEMPLATE_PROP + key.getValue(), "");
        }
    }
}

