/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.kieserver.backend.function;

import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import org.dashbuilder.external.impl.BackendComponentFunction;
import org.dashbuilder.kieserver.KieServerConnectionInfo;
import org.dashbuilder.kieserver.KieServerConnectionInfoProvider;
import org.dashbuilder.kieserver.backend.rest.KieServerQueryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class ProcessSVGFunction
implements BackendComponentFunction<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessSVGFunction.class);
    private static final String ERROR_REQUESTING_SVG = "Error requesting SVG from Kie Server: %s";
    private static final String NOT_FOUND_MSG = "Process SVG not found for container %s and process %s";
    private static final String CONTAINERID_PARAM = "containerId";
    private static final String PROCESSID_PARAM = "processId";
    private static final String SERVER_TEMPLATE_PARAM = "serverTemplate";
    @Inject
    KieServerQueryClient queryClient;
    @Inject
    KieServerConnectionInfoProvider connectionInfoProvider;

    public String exec(Map<String, Object> params) {
        String containerId = this.getRequiredParam(CONTAINERID_PARAM, params);
        String processId = this.getRequiredParam(PROCESSID_PARAM, params);
        Object serverTemplate = params.get(SERVER_TEMPLATE_PARAM);
        KieServerConnectionInfo connectionInfo = serverTemplate != null && !serverTemplate.toString().trim().isEmpty() ? (KieServerConnectionInfo)this.connectionInfoProvider.get(null, serverTemplate.toString()).orElseThrow(() -> new RuntimeException("Configuration for server template not found " + serverTemplate)) : (KieServerConnectionInfo)this.connectionInfoProvider.getDefault().orElseThrow(() -> new RuntimeException("Not able to find credentials to retrieve processes SVG"));
        try {
            return this.queryClient.processSVG(connectionInfo, containerId, processId);
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                this.notFoundSVGError(containerId, processId);
            }
            this.errorRetrievingSVG((Exception)((Object)e));
        }
        catch (Exception e) {
            this.errorRetrievingSVG(e);
        }
        return null;
    }

    private void errorRetrievingSVG(Exception e) {
        String message = String.format(ERROR_REQUESTING_SVG, e.getMessage());
        LOGGER.warn(message);
        LOGGER.debug(message, (Throwable)e);
        throw new RuntimeException(message, e);
    }

    private void notFoundSVGError(String containerId, String processId) {
        String notFoundMessage = String.format(NOT_FOUND_MSG, containerId, processId);
        LOGGER.warn(notFoundMessage);
        throw new RuntimeException(notFoundMessage);
    }

    private String getRequiredParam(String param, Map<String, Object> params) {
        Object value = params.get(param);
        if (value == null || value.toString().trim().isEmpty()) {
            throw new RuntimeException("Param '" + param + "' is required.");
        }
        return value.toString();
    }
}

