/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.kieserver.backend;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.kieserver.KieServerConnectionInfo;
import org.dashbuilder.kieserver.KieServerConnectionInfoProvider;
import org.dashbuilder.kieserver.RemoteDataSetDef;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class KieServerConnectionInfoProviderImpl
implements KieServerConnectionInfoProvider {
    static final String CONFIGURATION_NOT_FOUND_MESSAGE = "Configuration for dataset %s / server template %s not found";
    static final String MISSING_URL_MESSAGE = "URL configuration for dataset %s / server template %s is missing";
    static final String MISSING_AUTH_MESSAGE = "Auth configuration for dataset %s / server template %s is missing.You should provide user/password or token authentication";
    private static final String SERVER_TEMPLATE_SEPARATOR = ",";
    static final String DEFAULT_SERVER_TEMPLATE_PROPERTY = "dashbuilder.kieserver.defaultServerTemplate";
    static final String SERVER_TEMPLATE_LIST_PROPERTY = "dashbuilder.kieserver.serverTemplates";
    static final String SERVER_TEMPLATE_PROP_PREFFIX = "dashbuilder.kieserver.serverTemplate";
    static final String DATASET_PROP_PREFFIX = "dashbuilder.kieserver.dataset";
    private static final String SERVER_TEMPLATE_PROPERTY_TEMPLATE = "dashbuilder.kieserver.serverTemplate.%s.%s";
    private static final String REMOTE_DATASET_PROPERTY_TEMPLATE = "dashbuilder.kieserver.dataset.%s.%s";

    public List<String> serverTemplates() {
        return Optional.ofNullable(System.getProperty(SERVER_TEMPLATE_LIST_PROPERTY)).map(templates -> templates.split(SERVER_TEMPLATE_SEPARATOR)).map(template -> Arrays.stream(template).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public KieServerConnectionInfo verifiedConnectionInfo(RemoteDataSetDef def) {
        String name = def.getName();
        String serverTemplateId = def.getServerTemplateId();
        String missingConfigError = String.format(CONFIGURATION_NOT_FOUND_MESSAGE, name, serverTemplateId);
        String missingUrlError = String.format(MISSING_URL_MESSAGE, name, serverTemplateId);
        String missingAuthError = String.format(MISSING_AUTH_MESSAGE, name, serverTemplateId);
        KieServerConnectionInfo connectionInfo = this.get(name, serverTemplateId).orElseThrow(() -> new RuntimeException(missingConfigError));
        if (!connectionInfo.getLocation().isPresent()) {
            throw new RuntimeException(missingUrlError);
        }
        if (!connectionInfo.getUser().isPresent() && !connectionInfo.getToken().isPresent()) {
            throw new RuntimeException(missingAuthError);
        }
        return connectionInfo;
    }

    public Optional<KieServerConnectionInfo> get(String name, String serverTemplate) {
        Optional<KieServerConnectionInfo> optional = this.get(name, this::remoteDatasetProperty);
        if (!optional.isPresent()) {
            optional = this.get(serverTemplate, this::serverTemplateProperty);
        }
        return optional;
    }

    public Optional<String> serverTemplateProperty(String serverTemplate, KieServerConfigurationKey configurationKey) {
        String property = String.format(SERVER_TEMPLATE_PROPERTY_TEMPLATE, serverTemplate, configurationKey.value);
        return this.filteredProperty(property);
    }

    public Optional<String> remoteDatasetProperty(String datasetUUID, KieServerConfigurationKey configurationKey) {
        String property = String.format(REMOTE_DATASET_PROPERTY_TEMPLATE, datasetUUID, configurationKey.value);
        return this.filteredProperty(property);
    }

    public Optional<KieServerConnectionInfo> getDefault() {
        String defaultTemplate = System.getProperty(DEFAULT_SERVER_TEMPLATE_PROPERTY);
        if (defaultTemplate != null) {
            return this.get(null, defaultTemplate);
        }
        return this.findFirstServerTemplateConf().flatMap(template -> this.get(null, (String)template));
    }

    private Optional<String> filteredProperty(String property) {
        return Optional.ofNullable(System.getProperty(property)).filter(v -> !v.trim().isEmpty());
    }

    private Optional<KieServerConnectionInfo> get(String confType, BiFunction<String, KieServerConfigurationKey, Optional<String>> propertyProvider) {
        Optional<String> replaceQueryOp;
        Optional<String> token;
        Optional<String> password;
        Optional<String> user;
        Optional<String> url = propertyProvider.apply(confType, KieServerConfigurationKey.LOCATION);
        boolean noPropertyFound = Stream.of(url, user = propertyProvider.apply(confType, KieServerConfigurationKey.USER), password = propertyProvider.apply(confType, KieServerConfigurationKey.PASSWORD), token = propertyProvider.apply(confType, KieServerConfigurationKey.TOKEN), replaceQueryOp = propertyProvider.apply(confType, KieServerConfigurationKey.REPLACE_QUERY)).noneMatch(Optional::isPresent);
        if (noPropertyFound) {
            return Optional.empty();
        }
        boolean replaceQuery = replaceQueryOp.isPresent() && Boolean.TRUE.toString().equalsIgnoreCase(replaceQueryOp.get());
        return Optional.of(new KieServerConnectionInfo(url, user, password, token, replaceQuery));
    }

    Optional<String> findFirstServerTemplateConf() {
        return Collections.list(System.getProperties().keys()).stream().map(Object::toString).filter(key -> key.startsWith(SERVER_TEMPLATE_PROP_PREFFIX)).map(this::retrieveTemplateId).filter(Objects::nonNull).findFirst();
    }

    String retrieveTemplateId(String property) {
        String[] parts = property.replaceAll(SERVER_TEMPLATE_PROP_PREFFIX, "").split("\\.");
        if (parts.length > 1) {
            return parts[1];
        }
        return null;
    }

    public static enum KieServerConfigurationKey {
        LOCATION("location"),
        USER("user"),
        PASSWORD("password"),
        REPLACE_QUERY("replace_query"),
        TOKEN("token");

        private String value;

        private KieServerConfigurationKey(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

