/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.kieserver.backend.rest;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.dashbuilder.kieserver.KieServerConnectionInfo;
import org.dashbuilder.kieserver.backend.rest.BasicAuthFilter;
import org.dashbuilder.kieserver.backend.rest.QueryDefinition;
import org.dashbuilder.kieserver.backend.rest.QueryFilterSpec;
import org.dashbuilder.kieserver.backend.rest.TokenFilter;

@ApplicationScoped
public class KieServerQueryClient {
    private static final String PROCESS_ID_PARAM = "processId";
    private static final String CONTAINER_ID_PARAM = "containerId";
    private static final String DEFAULT_REQUEST_MEDIA_TYPE = "application/json";
    public static final String QUERY_MAP_RAW = "RawList";
    public static final String QUERY_DEFINITION_URI = "queries/definitions/{id}";
    public static final String QUERY_EXECUTION_URI = "queries/definitions/{id}/filtered-data";
    public static final String PROCESS_SVG_URI = "containers/{containerId}/images/processes/{processId}";

    public QueryDefinition getQuery(KieServerConnectionInfo connectionInfo, String uuid) {
        Client client = ClientBuilder.newClient();
        WebTarget target = this.requestForQueryDefinition(connectionInfo, uuid, client);
        QueryDefinition queryDefinition = (QueryDefinition)target.request().accept(new String[]{DEFAULT_REQUEST_MEDIA_TYPE}).get(QueryDefinition.class);
        client.close();
        return queryDefinition;
    }

    public List<List> query(KieServerConnectionInfo connectionInfo, String uuid, QueryFilterSpec filterSpec, int i, int numberOfRows) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target((String)connectionInfo.getLocation().get()).path(QUERY_EXECUTION_URI).resolveTemplate("id", (Object)uuid).queryParam("mapper", new Object[]{QUERY_MAP_RAW}).queryParam("page", new Object[]{i}).queryParam("pageSize", new Object[]{numberOfRows});
        this.addAuth(connectionInfo, target);
        List response = (List)target.request().accept(new String[]{DEFAULT_REQUEST_MEDIA_TYPE}).post(Entity.entity((Object)filterSpec, (String)DEFAULT_REQUEST_MEDIA_TYPE), List.class);
        client.close();
        return response;
    }

    public QueryDefinition replaceQuery(KieServerConnectionInfo connectionInfo, QueryDefinition queryDefinition) {
        Client client = ClientBuilder.newClient();
        WebTarget target = this.requestForQueryDefinition(connectionInfo, queryDefinition.getName(), client);
        QueryDefinition def = (QueryDefinition)target.request().accept(new String[]{DEFAULT_REQUEST_MEDIA_TYPE}).put(Entity.entity((Object)queryDefinition, (String)DEFAULT_REQUEST_MEDIA_TYPE), QueryDefinition.class);
        client.close();
        return def;
    }

    public void unregisterQuery(KieServerConnectionInfo connectionInfo, String dataSetUUID) {
        Client client = ClientBuilder.newClient();
        WebTarget target = this.requestForQueryDefinition(connectionInfo, dataSetUUID, client);
        target.request().delete();
        client.close();
    }

    public String processSVG(KieServerConnectionInfo connectionInfo, String containerId, String processId) {
        Optional location = connectionInfo.getLocation();
        if (location.isPresent()) {
            Client client = ClientBuilder.newClient();
            WebTarget target = client.target((String)location.get()).path(PROCESS_SVG_URI).resolveTemplate(CONTAINER_ID_PARAM, (Object)containerId).resolveTemplate(PROCESS_ID_PARAM, (Object)processId);
            this.addAuth(connectionInfo, target);
            String svg = (String)target.request().get(String.class);
            client.close();
            return svg;
        }
        throw new RuntimeException("Location for Kie Server is required. Check configuration.");
    }

    private WebTarget requestForQueryDefinition(KieServerConnectionInfo connectionInfo, String dataSetUUID, Client client) {
        WebTarget target = client.target((String)connectionInfo.getLocation().get()).path(QUERY_DEFINITION_URI).resolveTemplate("id", (Object)dataSetUUID);
        this.addAuth(connectionInfo, target);
        return target;
    }

    private void addAuth(KieServerConnectionInfo connectionInfo, WebTarget target) {
        if (connectionInfo.getUser().isPresent()) {
            String user = (String)connectionInfo.getUser().get();
            String password = connectionInfo.getPassword().orElse("");
            target.register((Object)new BasicAuthFilter(user, password));
        }
        if (connectionInfo.getToken().isPresent()) {
            target.register((Object)new TokenFilter((String)connectionInfo.getToken().get()));
        }
    }
}

