/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.kieserver.backend;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.kieserver.KieServerConnectionInfo;
import org.dashbuilder.kieserver.KieServerConnectionInfoProvider;
import org.dashbuilder.kieserver.RemoteDataSetDef;
import org.dashbuilder.kieserver.backend.rest.KieServerQueryClient;
import org.dashbuilder.kieserver.backend.rest.QueryDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KieServerDataSetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerDataSetListener.class);
    @Inject
    KieServerQueryClient queryClient;
    @Inject
    KieServerConnectionInfoProvider connectionInfoProvider;

    void onDataSetDefRegisteredEvent(@Observes DataSetDefRegisteredEvent event) {
        DataSetDef def = event.getDataSetDef();
        this.replaceQueryInKieServers(def);
    }

    void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        DataSetDef def = event.getNewDataSetDef();
        this.replaceQueryInKieServers(def);
    }

    void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (def instanceof RemoteDataSetDef) {
            try {
                KieServerConnectionInfo connectionInfo = this.connectionInfoProvider.verifiedConnectionInfo((RemoteDataSetDef)def);
                this.queryClient.unregisterQuery(connectionInfo, def.getUUID());
                LOGGER.info("Data set definition {} ({}) deletion event processed", (Object)def.getUUID(), (Object)def.getName());
            }
            catch (Exception e) {
                LOGGER.warn("Not able to delete query in server for removed dataset definition {} ", (Object)def.getName());
                LOGGER.debug("Not able to delete query in server for removed dataset definition {}", (Object)def.getName(), (Object)e);
            }
        }
    }

    protected void replaceQueryInKieServers(DataSetDef def) {
        if (def instanceof RemoteDataSetDef && ((RemoteDataSetDef)def).getServerTemplateId() != null) {
            try {
                KieServerConnectionInfo connectionInfo = this.connectionInfoProvider.verifiedConnectionInfo((RemoteDataSetDef)def);
                QueryDefinition queryDefinition = QueryDefinition.builder().name(def.getUUID()).source(((RemoteDataSetDef)def).getDataSource()).target(((RemoteDataSetDef)def).getQueryTarget()).expression(((RemoteDataSetDef)def).getDbSQL()).build();
                this.queryClient.replaceQuery(connectionInfo, queryDefinition);
                LOGGER.info("Data set definition {} ({}) modification event processed", (Object)def.getUUID(), (Object)def.getName());
            }
            catch (Exception e) {
                LOGGER.warn("Not able to replace query in server for dataset definition {} ", (Object)def.getName());
                LOGGER.debug("Not able to replace query in server for dataset definition {} ", (Object)def.getName(), (Object)e);
            }
        }
    }
}

