/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.kieserver.backend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.DataSetImpl;
import org.dashbuilder.kieserver.ConsoleDataSetLookup;
import org.dashbuilder.kieserver.KieServerConnectionInfo;
import org.dashbuilder.kieserver.KieServerConnectionInfoProvider;
import org.dashbuilder.kieserver.RemoteDataSetDef;
import org.dashbuilder.kieserver.backend.RuntimeKieServerDataSetProvider;
import org.dashbuilder.kieserver.backend.rest.KieServerQueryClient;
import org.dashbuilder.kieserver.backend.rest.QueryDefinition;
import org.dashbuilder.kieserver.backend.rest.QueryFilterSpec;
import org.dashbuilder.kieserver.backend.rest.QueryParam;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class RuntimeKieServerDataSetProviderTest {
    private static final String SERVER_TEMPLATE = "serverTemplate";
    public static String COLUMN_TEST = "columTest";
    @InjectMocks
    RuntimeKieServerDataSetProvider kieServerDataSetProvider;
    @Mock
    KieServerQueryClient queryClient;
    @Mock
    DataSetImpl dataSet;
    @Mock
    KieServerConnectionInfoProvider kieServerConnectionInfoProvider;
    @Mock
    RemoteDataSetDef dataSetDef;
    private KieServerConnectionInfo connectionInfo;
    private KieServerConnectionInfo connectionInfoWithQueryReplace;
    private QueryDefinition definition;

    @Before
    public void setUp() {
        this.connectionInfo = new KieServerConnectionInfo(Optional.of("location"), Optional.of("user"), Optional.of("password"), Optional.of("token"), false);
        this.connectionInfoWithQueryReplace = new KieServerConnectionInfo(Optional.of("location"), Optional.of("user"), Optional.of("password"), Optional.of("token"), true);
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put("test", "NUMBER");
        this.definition = QueryDefinition.builder().name("q1").columns(columns).build();
    }

    @Test
    public void appendEqualToIntervalSelectionTest() {
        String filterValue = "testValue";
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC));
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        Interval interval = new Interval(filterValue);
        intervalList.add(interval);
        dataSetGroup.setSelectedIntervalList(intervalList);
        ArrayList filterParams = new ArrayList();
        this.kieServerDataSetProvider.appendIntervalSelection(dataSetGroup, filterParams);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"EQUALS_TO", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((Object)filterValue, ((QueryParam)filterParams.get(0)).getValue().get(0));
    }

    @Test
    public void appendBetweenIntervalSelectionTest() {
        String filterValue = "testValue";
        Long minValue = 0L;
        Long maxValue = 2L;
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC));
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        Interval interval = new Interval(filterValue);
        interval.setMinValue((Object)minValue);
        interval.setMaxValue((Object)maxValue);
        intervalList.add(interval);
        dataSetGroup.setSelectedIntervalList(intervalList);
        ArrayList filterParams = new ArrayList();
        this.kieServerDataSetProvider.appendIntervalSelection(dataSetGroup, filterParams);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"BETWEEN", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((Object)minValue, ((QueryParam)filterParams.get(0)).getValue().get(0));
        Assert.assertEquals((Object)maxValue, ((QueryParam)filterParams.get(0)).getValue().get(1));
    }

    @Test
    public void lookupDataSetLogicalExprTest() throws Exception {
        DataSetLookup lookup = new DataSetLookup();
        lookup.setDataSetUUID("");
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"");
        Mockito.when((Object)this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.dataSetDef)).thenReturn((Object)this.connectionInfo);
        ColumnFilter testFilter = FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.likeTo((String)"column1", (String)"%value%"), FilterFactory.likeTo((String)"column2", (String)"%value%")});
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{testFilter});
        lookup.addOperation(new DataSetOp[]{filter});
        Mockito.when((Object)this.queryClient.getQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (String)ArgumentMatchers.any())).thenReturn((Object)this.definition);
        this.kieServerDataSetProvider.lookupDataSet((DataSetDef)this.dataSetDef, ConsoleDataSetLookup.fromInstance((DataSetLookup)lookup, (String)SERVER_TEMPLATE));
        ArgumentCaptor captorEdit = ArgumentCaptor.forClass(QueryFilterSpec.class);
        ((KieServerQueryClient)Mockito.verify((Object)this.queryClient)).query((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (String)ArgumentMatchers.any(), (QueryFilterSpec)captorEdit.capture(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assert.assertNotNull((Object)captorEdit.getValue());
        QueryParam[] parameters = ((QueryFilterSpec)captorEdit.getValue()).getParameters();
        Assert.assertEquals((long)1L, (long)parameters.length);
        List expr = parameters[0].getValue();
        Assert.assertEquals((Object)"OR", (Object)parameters[0].getOperator());
        Assert.assertEquals((Object)"column1 like %value%, true", (Object)((CoreFunctionFilter)expr.get(0)).toString());
        Assert.assertEquals((Object)"column2 like %value%, true", (Object)((CoreFunctionFilter)expr.get(1)).toString());
    }

    @Test
    public void testGroupWithInterval() {
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC, 30, DateIntervalType.DAY.name()));
        ArrayList filterParams = new ArrayList();
        ArrayList extraColumns = new ArrayList();
        this.kieServerDataSetProvider.handleDataSetGroup((DataSetDef)this.dataSetDef, dataSetGroup, filterParams, extraColumns);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"group", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((long)3L, (long)((QueryParam)filterParams.get(0)).getValue().size());
        Assert.assertEquals((Object)COLUMN_TEST, ((QueryParam)filterParams.get(0)).getValue().get(0));
        Assert.assertEquals((Object)DateIntervalType.DAY.name(), ((QueryParam)filterParams.get(0)).getValue().get(1));
        Assert.assertEquals((Object)30, ((QueryParam)filterParams.get(0)).getValue().get(2));
    }

    @Test
    public void testGroupWithNotSetInterval() {
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(new ColumnGroup(COLUMN_TEST, COLUMN_TEST, GroupStrategy.DYNAMIC));
        ArrayList filterParams = new ArrayList();
        ArrayList extraColumns = new ArrayList();
        this.kieServerDataSetProvider.handleDataSetGroup((DataSetDef)this.dataSetDef, dataSetGroup, filterParams, extraColumns);
        Assert.assertEquals((long)1L, (long)filterParams.size());
        Assert.assertEquals((Object)COLUMN_TEST, (Object)((QueryParam)filterParams.get(0)).getColumn());
        Assert.assertEquals((Object)"group", (Object)((QueryParam)filterParams.get(0)).getOperator());
        Assert.assertEquals((long)1L, (long)((QueryParam)filterParams.get(0)).getValue().size());
        Assert.assertEquals((Object)COLUMN_TEST, ((QueryParam)filterParams.get(0)).getValue().get(0));
    }

    @Test
    public void testPerformQueryTestMode() {
        QueryFilterSpec filterSpec = new QueryFilterSpec();
        ConsoleDataSetLookup dataSetLookup = (ConsoleDataSetLookup)Mockito.mock(ConsoleDataSetLookup.class);
        Mockito.when((Object)dataSetLookup.testMode()).thenReturn((Object)true);
        Mockito.when((Object)dataSetLookup.getNumberOfRows()).thenReturn((Object)10);
        Mockito.when((Object)dataSetLookup.getRowOffset()).thenReturn((Object)1);
        Mockito.when((Object)dataSetLookup.getDataSetUUID()).thenReturn((Object)"");
        Mockito.when((Object)this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.dataSetDef)).thenReturn((Object)this.connectionInfo);
        Mockito.when((Object)this.queryClient.replaceQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (QueryDefinition)ArgumentMatchers.any())).thenReturn((Object)this.definition);
        this.kieServerDataSetProvider.performQuery(this.dataSetDef, dataSetLookup, filterSpec);
        ((ConsoleDataSetLookup)Mockito.verify((Object)dataSetLookup, (VerificationMode)Mockito.times((int)1))).testMode();
        ((KieServerQueryClient)Mockito.verify((Object)this.queryClient)).replaceQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (QueryDefinition)ArgumentMatchers.any());
        ((KieServerQueryClient)Mockito.verify((Object)this.queryClient)).query((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (String)ArgumentMatchers.any(), (QueryFilterSpec)ArgumentMatchers.any(QueryFilterSpec.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testPerformQueryWithReplace() {
        QueryFilterSpec filterSpec = new QueryFilterSpec();
        ConsoleDataSetLookup dataSetLookup = (ConsoleDataSetLookup)Mockito.mock(ConsoleDataSetLookup.class);
        Mockito.when((Object)dataSetLookup.testMode()).thenReturn((Object)true);
        Mockito.when((Object)dataSetLookup.getNumberOfRows()).thenReturn((Object)10);
        Mockito.when((Object)dataSetLookup.getRowOffset()).thenReturn((Object)1);
        Mockito.when((Object)dataSetLookup.getDataSetUUID()).thenReturn((Object)"");
        Mockito.when((Object)this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.dataSetDef)).thenReturn((Object)this.connectionInfoWithQueryReplace);
        Mockito.when((Object)this.queryClient.replaceQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfoWithQueryReplace), (QueryDefinition)ArgumentMatchers.any())).thenReturn((Object)this.definition);
        this.kieServerDataSetProvider.performQuery(this.dataSetDef, dataSetLookup, filterSpec);
        ((ConsoleDataSetLookup)Mockito.verify((Object)dataSetLookup, (VerificationMode)Mockito.times((int)1))).testMode();
        ((KieServerQueryClient)Mockito.verify((Object)this.queryClient)).replaceQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfoWithQueryReplace), (QueryDefinition)ArgumentMatchers.any());
        ((KieServerQueryClient)Mockito.verify((Object)this.queryClient)).query((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfoWithQueryReplace), (String)ArgumentMatchers.any(), (QueryFilterSpec)ArgumentMatchers.any(QueryFilterSpec.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testPerformQueryRegularMode() {
        QueryFilterSpec filterSpec = new QueryFilterSpec();
        ConsoleDataSetLookup dataSetLookup = (ConsoleDataSetLookup)Mockito.mock(ConsoleDataSetLookup.class);
        Mockito.when((Object)dataSetLookup.testMode()).thenReturn((Object)false);
        Mockito.when((Object)dataSetLookup.getNumberOfRows()).thenReturn((Object)10);
        Mockito.when((Object)dataSetLookup.getRowOffset()).thenReturn((Object)1);
        Mockito.when((Object)dataSetLookup.getDataSetUUID()).thenReturn((Object)"");
        Mockito.when((Object)this.queryClient.getQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (String)ArgumentMatchers.any())).thenReturn((Object)this.definition);
        Mockito.when((Object)this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.dataSetDef)).thenReturn((Object)this.connectionInfo);
        this.kieServerDataSetProvider.performQuery(this.dataSetDef, dataSetLookup, filterSpec);
        ((ConsoleDataSetLookup)Mockito.verify((Object)dataSetLookup, (VerificationMode)Mockito.times((int)1))).testMode();
        ((KieServerQueryClient)Mockito.verify((Object)this.queryClient, (VerificationMode)Mockito.times((int)0))).replaceQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (QueryDefinition)ArgumentMatchers.any());
        ((KieServerQueryClient)Mockito.verify((Object)this.queryClient)).query((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (String)ArgumentMatchers.any(), (QueryFilterSpec)ArgumentMatchers.any(QueryFilterSpec.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testDataSetMetaData() throws Exception {
        Mockito.when((Object)this.kieServerConnectionInfoProvider.verifiedConnectionInfo(this.dataSetDef)).thenReturn((Object)this.connectionInfo);
        Mockito.when((Object)this.dataSetDef.getColumns()).thenReturn(null, (Object[])new List[]{new ArrayList()});
        Mockito.when((Object)this.queryClient.getQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (String)ArgumentMatchers.any())).thenReturn((Object)this.definition);
        this.kieServerDataSetProvider.getDataSetMetadata((DataSetDef)this.dataSetDef);
        ((RemoteDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).addColumn((String)ArgumentMatchers.eq((Object)"test"), (ColumnType)ArgumentMatchers.eq((Object)ColumnType.NUMBER));
        ((KieServerQueryClient)Mockito.verify((Object)this.queryClient)).getQuery((KieServerConnectionInfo)ArgumentMatchers.eq((Object)this.connectionInfo), (String)ArgumentMatchers.any());
    }

    @Test
    public void testNoAdoptLookup() throws Exception {
        ConsoleDataSetLookup dataSetLookup = (ConsoleDataSetLookup)Mockito.mock(ConsoleDataSetLookup.class);
        this.kieServerDataSetProvider.adoptLookup((DataSetDef)this.dataSetDef, (DataSetLookup)dataSetLookup);
        ((RemoteDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).getServerTemplateId();
    }

    @Test
    public void testAdoptLookup() throws Exception {
        DataSetLookup dataSetLookup = (DataSetLookup)Mockito.mock(DataSetLookup.class);
        Mockito.when((Object)this.dataSetDef.getDataSetFilter()).thenReturn((Object)((DataSetFilter)Mockito.mock(DataSetFilter.class)));
        Mockito.when((Object)this.dataSetDef.getServerTemplateId()).thenReturn((Object)"servereTemplateId");
        ConsoleDataSetLookup adopted = this.kieServerDataSetProvider.adoptLookup((DataSetDef)this.dataSetDef, dataSetLookup);
        ((RemoteDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).getServerTemplateId();
        Assert.assertNotNull((Object)adopted.getOperationList());
        Assert.assertEquals((long)1L, (long)adopted.getOperationList().size());
    }

    @Test
    public void testGroupFunctionColumnType() {
        for (ColumnType type : ColumnType.values()) {
            this.assertGroupFuntionColumnType(type, type == ColumnType.DATE ? ColumnType.LABEL : type);
        }
    }

    protected void assertGroupFuntionColumnType(ColumnType source, ColumnType expected) {
        DataSetDef def = new DataSetDef();
        def.addColumn("columnId", source);
        ColumnGroup columnGroup = new ColumnGroup("sourceId", "columnId");
        GroupFunction groupFunction = new GroupFunction("sourceId", "columnId", null);
        Assert.assertEquals((Object)expected, (Object)this.kieServerDataSetProvider.getGroupFunctionColumnType(def, columnGroup, groupFunction));
    }
}

