/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation;

import com.google.gwt.user.client.ui.IsWidget;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.NavItemEditor;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveDropDown;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class NavItemEditorTest {
    @Mock
    NavItemEditor.View view;
    @Mock
    PlaceManager placeManager;
    @Mock
    PerspectiveDropDown perspectiveDropDown;
    @Mock
    PerspectivePluginManager perspectivePluginManager;
    NavItemEditor presenter;

    @Before
    public void setUp() throws Exception {
        this.presenter = new NavItemEditor(this.view, this.placeManager, this.perspectiveDropDown, this.perspectivePluginManager);
    }

    @Test
    public void testEditGroup() {
        NavGroup navGroup = NavFactory.get().createNavGroup();
        navGroup.setId("id");
        navGroup.setName("name");
        navGroup.setDescription("description");
        navGroup.setModifiable(false);
        this.presenter.edit((NavItem)navGroup);
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemName("name");
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemDescription("description");
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemEditable(false);
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemType(NavItemEditor.ItemType.GROUP);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).addCommand((String)Mockito.any(), (Command)Mockito.any());
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setContextWidget((IsWidget)Mockito.any());
    }

    @Test
    public void testEditDivider() {
        NavDivider divider = NavFactory.get().createDivider();
        divider.setId("id");
        divider.setName("name");
        divider.setDescription("description");
        divider.setModifiable(true);
        this.presenter.edit((NavItem)divider);
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemName("name");
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemDescription("description");
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemEditable(false);
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemType(NavItemEditor.ItemType.DIVIDER);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).addCommand((String)Mockito.any(), (Command)Mockito.any());
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setContextWidget((IsWidget)Mockito.any());
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        this.presenter.onItemClick();
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).startItemEdition();
    }

    @Test
    public void testEditPerspective() {
        NavItem navItem = NavFactory.get().createNavItem();
        navItem.setModifiable(false);
        navItem.setContext(NavWorkbenchCtx.perspective((String)"p1").toString());
        this.presenter.edit(navItem);
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemName("--------------");
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemEditable(false);
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setItemType(NavItemEditor.ItemType.PERSPECTIVE);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).addCommand((String)Mockito.any(), (Command)Mockito.any());
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setContextWidget((IsWidget)this.perspectiveDropDown);
    }

    @Test
    public void testCommandsAvailability() {
        this.presenter.setMoveUpEnabled(false);
        this.presenter.setMoveDownEnabled(false);
        NavGroup navGroup = NavFactory.get().createNavGroup();
        navGroup.setModifiable(false);
        this.presenter.edit((NavItem)navGroup);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        navGroup.setModifiable(true);
        this.presenter.edit((NavItem)navGroup);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        NavItem navItem = NavFactory.get().createNavItem();
        navItem.setContext(NavWorkbenchCtx.perspective((String)"p1").toString());
        navItem.setModifiable(false);
        this.presenter.edit(navItem);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        navItem.setModifiable(true);
        this.presenter.edit(navItem);
        ((NavItemEditor.View)Mockito.verify((Object)this.view)).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        NavDivider navDivider = NavFactory.get().createDivider();
        navDivider.setModifiable(true);
        this.presenter.edit((NavItem)navDivider);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        navDivider.setModifiable(false);
        this.presenter.edit((NavItem)navDivider);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        this.presenter.setMoveUpEnabled(true);
        this.presenter.setMoveDownEnabled(true);
        this.presenter.edit(navItem);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        this.presenter.edit((NavItem)navDivider);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemEditor.View[]{this.view});
        this.presenter.edit((NavItem)navGroup);
        ((NavItemEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
    }
}

