/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation;

import com.google.gwt.user.client.Command;
import org.dashbuilder.client.navigation.widget.NavItemSelectionModal;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NavItemSelectionModalTest {
    @Mock
    NavItemSelectionModal.View view;
    NavTree tree;
    NavItemSelectionModal presenter;

    @Before
    public void setUp() throws Exception {
        this.tree = new NavTreeBuilder().item("H1", "H1", null, false).divider().group("A", "A", null, false).item("A1", "A1", null, false).item("A2", "A2", null, false).group("B", "B", null, false).group("C", "C", null, false).build();
        this.presenter = new NavItemSelectionModal(this.view);
        this.presenter.setOnlyGroups(true);
    }

    @Test
    public void testInitDefaultAll() {
        this.presenter.setOnlyGroups(false);
        this.presenter.show(this.tree.getRootItems(), null);
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).clearItems();
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).setCurrentSelection("H1");
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>A1"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>A2"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>B"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>B>C"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testInitSelectedAll() {
        this.presenter.setOnlyGroups(false);
        this.presenter.show(this.tree.getRootItems(), "B");
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).clearItems();
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).setCurrentSelection("A>B");
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"H1"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>A1"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>A2"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>B>C"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testInitDefaultOnlyGroups() {
        this.presenter.setOnlyGroups(true);
        this.presenter.show(this.tree.getRootItems(), null);
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).clearItems();
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).setCurrentSelection("A");
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>B"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>B>C"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testInitSelectedOnlyGroups() {
        this.presenter.setOnlyGroups(true);
        this.presenter.show(this.tree.getRootItems(), "B");
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).clearItems();
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).setCurrentSelection("A>B");
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>B>C"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testSelectItem() {
        this.presenter.show(this.tree.getRootItems(), "A");
        Mockito.reset((Object[])new NavItemSelectionModal.View[]{this.view});
        NavItem navItem = this.tree.getItemById("B");
        this.presenter.onItemSelected(navItem);
        Assert.assertEquals((Object)this.presenter.getSelectedItem(), (Object)navItem);
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).clearItems();
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).setCurrentSelection("A>B");
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A"), (Command)Mockito.any());
        ((NavItemSelectionModal.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)"A>B>C"), (Command)Mockito.any());
    }
}

