/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation;

import java.lang.annotation.Annotation;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.NavItemTileWidget;
import org.dashbuilder.client.navigation.widget.NavTilesWidget;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class NavTilesWidgetTest {
    @Mock
    NavTilesWidget.View view;
    @Mock
    PerspectivePluginManager pluginManager;
    @Mock
    NavigationManager navigationManager;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    PlaceManager placeManager;
    @Mock
    SyncBeanDef<NavItemTileWidget> tileWidgetBeanDef;
    @Mock
    NavItemTileWidget tileWidget;
    NavTilesWidget presenter;
    NavTree tree;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.beanManager.lookupBean(NavItemTileWidget.class, new Annotation[0])).thenReturn(this.tileWidgetBeanDef);
        Mockito.when((Object)this.tileWidgetBeanDef.getInstance()).thenReturn((Object)this.tileWidget);
        this.presenter = new NavTilesWidget(this.view, this.navigationManager, this.pluginManager, this.placeManager, this.beanManager);
        this.tree = new NavTreeBuilder().group("Home", "Home", null, false).group("A", "A", null, false).item("A1", "A1", null, false).item("A2", "A2", null, false).group("A3", "A3", null, false).item("A31", "A3", null, false).build();
    }

    @Test
    public void testOpenItem() {
        NavItem navItem = this.tree.getItemById("A");
        this.presenter.openItem(navItem);
        Assert.assertEquals((long)this.presenter.getNavItemStack().size(), (long)2L);
        ((NavTilesWidget.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addTileWidget((IsElement)this.tileWidget);
        ((NavTilesWidget.View)Mockito.verify((Object)this.view)).clearBreadcrumb();
        ((NavTilesWidget.View)Mockito.verify((Object)this.view)).addBreadcrumbItem((String)Mockito.eq((Object)"Home"), (Command)Mockito.any());
        ((NavTilesWidget.View)Mockito.verify((Object)this.view)).addBreadcrumbItem((String)Mockito.eq((Object)"A"));
        Mockito.reset((Object[])new NavTilesWidget.View[]{this.view});
        navItem = this.tree.getItemById("A3");
        this.presenter.openItem(navItem);
        Assert.assertEquals((long)this.presenter.getNavItemStack().size(), (long)3L);
        ((NavTilesWidget.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addTileWidget((IsElement)this.tileWidget);
        ((NavTilesWidget.View)Mockito.verify((Object)this.view)).clearBreadcrumb();
        ((NavTilesWidget.View)Mockito.verify((Object)this.view)).addBreadcrumbItem((String)Mockito.eq((Object)"Home"), (Command)Mockito.any());
        ((NavTilesWidget.View)Mockito.verify((Object)this.view)).addBreadcrumbItem((String)Mockito.eq((Object)"A"), (Command)Mockito.any());
        ((NavTilesWidget.View)Mockito.verify((Object)this.view)).addBreadcrumbItem((String)Mockito.eq((Object)"A3"));
    }

    @Test
    public void testGotoHome() {
        NavItem navItem = this.tree.getItemById("A");
        this.presenter.openItem(navItem);
        Mockito.reset((Object[])new NavTilesWidget.View[]{this.view});
        NavItem homeItem = this.tree.getItemById("Home");
        this.presenter.gotoBreadcrumbItem(homeItem);
        Assert.assertEquals((long)this.presenter.getNavItemStack().size(), (long)0L);
        ((NavTilesWidget.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addTileWidget((IsElement)this.tileWidget);
        ((NavTilesWidget.View)Mockito.verify((Object)this.view)).clearBreadcrumb();
        ((NavTilesWidget.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addBreadcrumbItem((String)Mockito.any(), (Command)Mockito.any());
    }
}

