/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.plugin;

import javax.enterprise.event.Event;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectivePluginManagerTest {
    private static final String ID_TO_DELETE = "Persp1";
    public static final NavTree TEST_NAV_TREE = new NavTreeBuilder().item("Persp1", "name1", "desciption1", true, (NavItemContext)NavWorkbenchCtx.perspective((String)"Persp1")).build();
    @Mock
    private NavigationManager navigationManagerMock;
    @Mock
    private PluginDeleted pluginDeletedEventMock;
    @Mock
    private Event<PerspectivePluginsChangedEvent> perspectiveChangedEventMock;

    @Test
    public void whenPluginDeleted_itIsRemovedFromNavTree() {
        NavTree testTree = TEST_NAV_TREE.cloneTree();
        Assert.assertNotNull((Object)testTree.getItemById(ID_TO_DELETE));
        Mockito.when((Object)this.navigationManagerMock.getNavTree()).thenReturn((Object)testTree);
        Mockito.when((Object)this.pluginDeletedEventMock.getPluginName()).thenReturn((Object)ID_TO_DELETE);
        PerspectivePluginManager testedPluginManager = new PerspectivePluginManager(null, null, this.navigationManagerMock, null, null, this.perspectiveChangedEventMock);
        testedPluginManager.onPlugInDeleted(this.pluginDeletedEventMock);
        Assert.assertNull((String)"Plugin should be removed from the tree when PluginDeleted event occurs", (Object)testTree.getItemById(ID_TO_DELETE));
        ((NavigationManager)Mockito.verify((Object)this.navigationManagerMock)).saveNavTree((NavTree)Matchers.anyObject(), (Command)Matchers.eq(null));
        ((Event)Mockito.verify(this.perspectiveChangedEventMock)).fire(Matchers.anyObject());
    }
}

