/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.layout.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.NavCarouselWidget;
import org.dashbuilder.client.navigation.widget.NavItemSelectionModal;
import org.dashbuilder.client.navigation.widget.NavItemSelectionModalView;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.gwtbootstrap3.client.ui.Modal;
import org.uberfire.ext.layout.editor.client.api.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorDragComponent;

@Dependent
public class NavCarouselDragComponent
implements PerspectiveEditorDragComponent,
HasModalConfiguration {
    NavigationManager navigationManager;
    NavItemSelectionModal navItemSelectionModal;
    NavCarouselWidget navCarouselWidget;
    String navGroupId = null;
    public static final String NAV_GROUP_ID = "navGroupId";

    @Inject
    public NavCarouselDragComponent(NavigationManager navigationManager, NavItemSelectionModal navItemSelectionModal, NavCarouselWidget navCarouselWidget) {
        this.navigationManager = navigationManager;
        this.navItemSelectionModal = navItemSelectionModal;
        this.navCarouselWidget = navCarouselWidget;
        this.navCarouselWidget.setOnStaleCommand(this::showNavTabList);
    }

    public String getDragComponentTitle() {
        return NavigationConstants.INSTANCE.navCarouselDragComponent();
    }

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        return this.getShowWidget(ctx);
    }

    public IsWidget getShowWidget(RenderingContext ctx) {
        Map properties = ctx.getComponent().getProperties();
        this.navGroupId = (String)properties.get(NAV_GROUP_ID);
        this.showNavTabList();
        return this.navCarouselWidget;
    }

    private void showNavTabList() {
        NavTree navTree = this.navigationManager.getNavTree();
        NavGroup navGroup = (NavGroup)navTree.getItemById(this.navGroupId);
        if (navGroup != null) {
            this.navCarouselWidget.show(navGroup);
        } else {
            this.navCarouselWidget.show(Collections.emptyList());
        }
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        this.navItemSelectionModal.setHelpHint(NavigationConstants.INSTANCE.navCarouselDragComponentHelp());
        this.navItemSelectionModal.setOnlyGroups(true);
        this.navItemSelectionModal.setOnOk(() -> this.navGroupSelectionOk(ctx));
        this.navItemSelectionModal.setOnCancel(() -> this.navGroupSelectionCancel(ctx));
        NavTree navTree = this.navigationManager.getNavTree();
        String groupId = ctx.getComponentProperty(NAV_GROUP_ID);
        this.navItemSelectionModal.show(navTree.getRootItems(), groupId);
        return ((NavItemSelectionModalView)this.navItemSelectionModal.getView()).getModal();
    }

    private void navGroupSelectionOk(ModalConfigurationContext ctx) {
        NavItem navItem = this.navItemSelectionModal.getSelectedItem();
        ctx.setComponentProperty(NAV_GROUP_ID, navItem.getId());
        ctx.configurationFinished();
    }

    private void navGroupSelectionCancel(ModalConfigurationContext ctx) {
        ctx.configurationCancelled();
    }
}

