/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.plugin;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.layout.editor.api.LayoutServices;
import org.uberfire.ext.layout.editor.client.generator.LayoutGenerator;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.ActivityResourceType;

@EntryPoint
@ApplicationScoped
public class PerspectivePluginManager {
    private ClientTypeRegistry clientTypeRegistry;
    private LayoutGenerator layoutGenerator;
    private NavigationManager navigationManager;
    private Caller<PluginServices> pluginServices;
    private Caller<LayoutServices> layoutServices;
    private Event<PerspectivePluginsChangedEvent> perspectivesChangedEvent;
    private Map<String, Plugin> pluginMap = new HashMap<String, Plugin>();
    private Set<String> perspectiveNames = new HashSet<String>();

    @Inject
    public PerspectivePluginManager(ClientTypeRegistry clientTypeRegistry, LayoutGenerator layoutGenerator, NavigationManager navigationManager, Caller<PluginServices> pluginServices, Caller<LayoutServices> layoutServices, Event<PerspectivePluginsChangedEvent> perspectivesChangedEvent) {
        this.clientTypeRegistry = clientTypeRegistry;
        this.layoutGenerator = layoutGenerator;
        this.navigationManager = navigationManager;
        this.pluginServices = pluginServices;
        this.layoutServices = layoutServices;
        this.perspectivesChangedEvent = perspectivesChangedEvent;
    }

    @AfterInitialization
    private void init() {
        ((PluginServices)this.pluginServices.call(plugins -> plugins.stream().filter(this::isRuntimePerspective).forEach(p -> this.pluginMap.put(p.getName(), (Plugin)p)))).listPlugins();
    }

    public List<Plugin> getPerspectivePlugins() {
        return new ArrayList<Plugin>(this.pluginMap.values());
    }

    public boolean isRuntimePerspective(Plugin plugin) {
        ClientResourceType type = this.clientTypeRegistry.resolve(plugin.getPath());
        return type != null && type instanceof PerspectiveLayoutPluginResourceType;
    }

    public boolean isRuntimePerspective(NavItem navItem) {
        return this.getRuntimePerspectiveId(navItem) != null;
    }

    public boolean isRuntimePerspective(String perspectiveId) {
        return this.pluginMap.containsKey(perspectiveId);
    }

    public String getRuntimePerspectiveId(NavItem navItem) {
        NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)navItem);
        String resourceId = navCtx.getResourceId();
        ActivityResourceType resourceType = navCtx.getResourceType();
        boolean isRuntimePerspective = resourceId != null && ActivityResourceType.PERSPECTIVE.equals((Object)resourceType) && this.isRuntimePerspective(resourceId);
        return isRuntimePerspective ? resourceId : null;
    }

    public void buildPerspectiveWidget(String perspectiveName, ParameterizedCommand<IsWidget> afterBuild, Command onRecursivity) {
        Plugin plugin = this.pluginMap.get(perspectiveName);
        if (plugin != null) {
            this.buildPerspectiveWidget(plugin, afterBuild, onRecursivity);
        }
    }

    public void buildPerspectiveWidget(Plugin perspectivePlugin, ParameterizedCommand<IsWidget> afterBuild, Command onRecursivity) {
        String perspectiveName = perspectivePlugin.getName();
        if (this.perspectiveNames.contains(perspectiveName) && onRecursivity != null) {
            onRecursivity.execute();
        } else {
            this.perspectiveNames.add(perspectiveName);
            ((PluginServices)this.pluginServices.call(layoutEditorModel -> ((LayoutServices)this.layoutServices.call(layoutTemplate -> {
                if (layoutTemplate != null) {
                    Panel result = this.layoutGenerator.build(layoutTemplate);
                    afterBuild.execute((Object)result);
                    this.perspectiveNames.remove(perspectiveName);
                }
            })).convertLayoutFromString(layoutEditorModel.getLayoutEditorModel()))).getLayoutEditor(perspectivePlugin.getPath(), PluginType.PERSPECTIVE_LAYOUT);
        }
    }

    public void onPlugInAdded(@Observes PluginAdded event) {
        Plugin plugin = event.getPlugin();
        if (this.isRuntimePerspective(plugin)) {
            this.pluginMap.put(plugin.getName(), plugin);
            this.perspectivesChangedEvent.fire((Object)new PerspectivePluginsChangedEvent());
        }
    }

    public void onPlugInSaved(@Observes PluginSaved event) {
        Plugin plugin = event.getPlugin();
        if (this.isRuntimePerspective(plugin)) {
            this.pluginMap.put(plugin.getName(), plugin);
        }
    }

    public void onPlugInRenamed(@Observes PluginRenamed event) {
        Plugin plugin = event.getPlugin();
        if (this.isRuntimePerspective(plugin)) {
            this.pluginMap.remove(event.getOldPluginName());
            this.pluginMap.put(plugin.getName(), plugin);
            NavWorkbenchCtx ctx = NavWorkbenchCtx.perspective((String)event.getOldPluginName());
            NavWorkbenchCtx newCtx = NavWorkbenchCtx.perspective((String)event.getPlugin().getName());
            List itemsToRename = this.navigationManager.getNavTree().searchItems((NavItemContext)ctx);
            for (NavItem navItem : itemsToRename) {
                navItem.setContext(newCtx.toString());
            }
            if (!itemsToRename.isEmpty()) {
                this.navigationManager.saveNavTree(this.navigationManager.getNavTree(), () -> {});
            }
            this.perspectivesChangedEvent.fire((Object)new PerspectivePluginsChangedEvent());
        }
    }

    public void onPlugInDeleted(@Observes PluginDeleted event) {
        String pluginName = event.getPluginName();
        this.pluginMap.remove(pluginName);
        NavWorkbenchCtx ctx = NavWorkbenchCtx.perspective((String)pluginName);
        NavTree navTree = this.navigationManager.getNavTree();
        List itemsToDelete = navTree.searchItems((NavItemContext)ctx);
        for (NavItem item : itemsToDelete) {
            navTree.deleteItem(item.getId());
        }
        if (!itemsToDelete.isEmpty()) {
            this.navigationManager.saveNavTree(navTree, null);
        }
        this.perspectivesChangedEvent.fire((Object)new PerspectivePluginsChangedEvent());
    }
}

