/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.BaseNavWidget;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.dashbuilder.navigation.NavItem;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class NavCarouselWidget
extends BaseNavWidget {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    List<String> perspectiveIds = new ArrayList<String>();

    @Inject
    public NavCarouselWidget(View view, NavigationManager navigationManager, PerspectivePluginManager perspectivePluginManager) {
        super(view, navigationManager);
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        super.setMaxLevels(1);
    }

    @Override
    public boolean areSubGroupsSupported() {
        return false;
    }

    @Override
    public void show(List<NavItem> itemList) {
        List<NavItem> itemsFiltered = itemList.stream().filter(this.perspectivePluginManager::isRuntimePerspective).collect(Collectors.toList());
        this.perspectiveIds.clear();
        super.show(itemsFiltered);
    }

    @Override
    protected void showItem(NavItem navItem) {
        String perspectiveId = this.perspectivePluginManager.getRuntimePerspectiveId(navItem);
        if (perspectiveId != null) {
            this.perspectiveIds.add(perspectiveId);
            this.perspectivePluginManager.buildPerspectiveWidget(perspectiveId, (ParameterizedCommand<IsWidget>)((ParameterizedCommand)this::showWidget), this::recursivityError);
        }
    }

    public void showWidget(IsWidget widget) {
        this.view.addContentSlide(widget);
    }

    private void recursivityError() {
        this.view.recursivityError();
    }

    private void onPerspectiveChanged(@Observes PluginSaved event) {
        Plugin plugin = event.getPlugin();
        String pluginName = plugin.getName();
        if (this.perspectiveIds.contains(pluginName)) {
            super.refresh();
        }
    }

    public static interface View
    extends NavWidgetView<NavCarouselWidget> {
        public void addContentSlide(IsWidget var1);

        public void recursivityError();
    }
}

