/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.layout.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.Map;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.layout.editor.NavDragComponent;
import org.dashbuilder.client.navigation.layout.editor.NavDragComponentRegistry;
import org.dashbuilder.client.navigation.widget.NavItemSelectionModal;
import org.dashbuilder.client.navigation.widget.NavItemSelectionModalView;
import org.dashbuilder.client.navigation.widget.NavWidget;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.gwtbootstrap3.client.ui.Modal;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;

public abstract class AbstractNavDragComponent
implements NavDragComponent {
    NavigationManager navigationManager;
    NavDragComponentRegistry navDragComponentRegistry;
    NavItemSelectionModal navItemSelectionModal;
    NavWidget navWidget;
    String navGroupId = null;
    public static final String NAV_GROUP_ID = "navGroupId";

    public AbstractNavDragComponent() {
    }

    public AbstractNavDragComponent(NavigationManager navigationManager, NavDragComponentRegistry navDragComponentRegistry, NavItemSelectionModal navItemSelectionModal, NavWidget navWidget) {
        this.navigationManager = navigationManager;
        this.navDragComponentRegistry = navDragComponentRegistry;
        this.navItemSelectionModal = navItemSelectionModal;
        this.navWidget = navWidget;
        this.navWidget.setOnStaleCommand(this::showNavWidget);
        this.navDragComponentRegistry.checkIn(this);
    }

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        return this.getShowWidget(ctx);
    }

    public IsWidget getShowWidget(RenderingContext ctx) {
        Map properties = ctx.getComponent().getProperties();
        this.navGroupId = (String)properties.get(NAV_GROUP_ID);
        this.showNavWidget();
        return this.navWidget;
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        this.navItemSelectionModal.setHelpHint(this.getDragComponentHelp());
        this.navItemSelectionModal.setOnlyGroups(true);
        this.navItemSelectionModal.setOnOk(() -> this.navGroupSelectionOk(ctx));
        this.navItemSelectionModal.setOnCancel(() -> this.navGroupSelectionCancel(ctx));
        NavTree navTree = this.navigationManager.getNavTree();
        String groupId = ctx.getComponentProperty(NAV_GROUP_ID);
        this.navItemSelectionModal.show(navTree.getRootItems(), groupId);
        return ((NavItemSelectionModalView)this.navItemSelectionModal.getView()).getModal();
    }

    @Override
    public void dispose() {
        this.navWidget.dispose();
    }

    protected NavGroup fetchNavGroup() {
        NavTree navTree = this.navigationManager.getNavTree();
        return (NavGroup)navTree.getItemById(this.navGroupId);
    }

    protected void showNavWidget() {
        NavGroup navGroup = this.fetchNavGroup();
        if (navGroup != null) {
            this.navWidget.show(navGroup);
        } else {
            this.navWidget.show(Collections.emptyList());
        }
    }

    protected void navGroupSelectionOk(ModalConfigurationContext ctx) {
        NavItem navItem = this.navItemSelectionModal.getSelectedItem();
        ctx.setComponentProperty(NAV_GROUP_ID, navItem.getId());
        ctx.configurationFinished();
    }

    protected void navGroupSelectionCancel(ModalConfigurationContext ctx) {
        ctx.configurationCancelled();
    }
}

