/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LIElement;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.widget.BaseNavWidgetView;
import org.dashbuilder.client.navigation.widget.NavDropDownWidget;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class NavDropDownWidgetView
extends BaseNavWidgetView<NavDropDownWidget>
implements NavDropDownWidget.View {
    @Inject
    @DataField
    ListItem dropDownItem;
    @Inject
    @DataField
    Anchor dropDownAnchor;
    @Inject
    @DataField
    Span dropDownName;
    @Inject
    @DataField
    UnorderedList dropDownMenu;
    NavDropDownWidget presenter;
    boolean active = false;
    boolean submenu = false;

    public void init(NavDropDownWidget presenter) {
        this.presenter = presenter;
        this.navWidget = this.dropDownMenu;
    }

    @Override
    public void setDropDownName(String name) {
        this.dropDownName.setTextContent(name);
    }

    private String calculateDropDownClassName() {
        if (this.submenu) {
            if (this.active) {
                return "dropdown-submenu active";
            }
            return "dropdown-submenu";
        }
        if (this.active) {
            return "dropdown active";
        }
        return "dropdown";
    }

    @Override
    public void showAsSubmenu(boolean enabled) {
        this.submenu = enabled;
        String className = this.calculateDropDownClassName();
        this.dropDownItem.setClassName(className);
        if (enabled) {
            DOMUtil.removeAllChildren((Node)this.dropDownAnchor);
            this.dropDownAnchor.appendChild((Node)this.dropDownName);
        }
    }

    @Override
    public void setActive(boolean active) {
        if (this.presenter.getLevel() == 1) {
            this.active = active;
            String className = this.calculateDropDownClassName();
            this.dropDownItem.setClassName(className);
        }
    }

    @Override
    public void addDivider() {
        LIElement li = Document.get().createLIElement();
        li.setClassName("divider");
        this.dropDownMenu.appendChild((Node)li);
    }

    @Override
    public void errorNavItemNotFound(String navItemId) {
        this.setDropDownName("Not found: " + navItemId);
    }
}

