/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.uberfire.client.mvp.UberView;

@Dependent
public class NavItemSelectionModal
implements IsWidget {
    View view;
    NavItem selectedItem = null;
    boolean onlyGroups = true;
    List<NavItem> navItemList = null;
    Command onOk = null;
    Command onCancel = null;

    @Inject
    public NavItemSelectionModal(View view) {
        this.view = view;
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public View getView() {
        return this.view;
    }

    public void setOnlyGroups(boolean onlyGroups) {
        this.onlyGroups = onlyGroups;
    }

    public void setOnOk(Command onOk) {
        this.onOk = onOk;
    }

    public void setOnCancel(Command onCancel) {
        this.onCancel = onCancel;
    }

    public void setHelpHint(String text) {
        this.view.setHelpText(text);
    }

    public NavItem getSelectedItem() {
        return this.selectedItem;
    }

    public void show(List<NavItem> navItemList, String selectedItemId) {
        this.view.clearItems();
        this.navItemList = navItemList;
        this.addItems(navItemList, selectedItemId);
        this.view.show();
    }

    private void addItems(List<NavItem> navItemList, String selectedItemId) {
        for (NavItem navItem : navItemList) {
            if (navItem instanceof NavDivider || this.onlyGroups && !(navItem instanceof NavGroup)) continue;
            String fullPath = this.calculateFullPath(navItem);
            if (selectedItemId == null && this.selectedItem == null || selectedItemId != null && navItem.getId().equals(selectedItemId)) {
                this.selectedItem = navItem;
                this.view.setCurrentSelection(fullPath);
            } else {
                this.view.addItem(fullPath, () -> this.onItemSelected(navItem));
            }
            if (!(navItem instanceof NavGroup)) continue;
            this.addItems(((NavGroup)navItem).getChildren(), selectedItemId);
        }
    }

    public String calculateFullPath(NavItem navItem) {
        StringBuilder out = new StringBuilder();
        for (NavGroup parent = navItem.getParent(); parent != null; parent = parent.getParent()) {
            out.insert(0, parent.getName() + ">");
        }
        out.append(navItem.getName());
        return out.toString();
    }

    public void onItemSelected(NavItem navItem) {
        this.show(this.navItemList, navItem.getId());
    }

    void onOk() {
        if (this.selectedItem != null) {
            this.view.hide();
            if (this.onOk != null) {
                this.onOk.execute();
            }
        }
    }

    void onCancel() {
        this.view.hide();
        if (this.onCancel != null) {
            this.onCancel.execute();
        }
    }

    public static interface View
    extends UberView<NavItemSelectionModal> {
        public void clearItems();

        public void addItem(String var1, Command var2);

        public void setCurrentSelection(String var1);

        public void setHelpText(String var1);

        public void show();

        public void hide();
    }
}

