/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.BaseNavWidget;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.dashbuilder.navigation.NavItem;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class NavTabListWidget
extends BaseNavWidget {
    View view;
    PerspectivePluginManager perspectivePluginManager;

    @Inject
    public NavTabListWidget(View view, NavigationManager navigationManager, PerspectivePluginManager perspectivePluginManager) {
        super(view, navigationManager);
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        super.setMaxLevels(1);
    }

    @Override
    public boolean areSubGroupsSupported() {
        return false;
    }

    @Override
    public void show(List<NavItem> itemList) {
        List<NavItem> itemsFiltered = itemList.stream().filter(this.perspectivePluginManager::isRuntimePerspective).collect(Collectors.toList());
        super.show(itemsFiltered);
        if (!this.navItemList.isEmpty()) {
            this.setSelectedItem(((NavItem)this.navItemList.get(0)).getId());
        }
    }

    public void showPerspective(NavItem navItem) {
        String perspectiveId = this.perspectivePluginManager.getRuntimePerspectiveId(navItem);
        if (perspectiveId != null) {
            this.showPerspective(perspectiveId);
        }
    }

    public void showPerspective(String perspectiveId) {
        this.perspectivePluginManager.buildPerspectiveWidget(perspectiveId, (ParameterizedCommand<IsWidget>)((ParameterizedCommand)this::showWidget), this::deadlockError);
    }

    public void showWidget(IsWidget widget) {
        this.view.showContent(widget);
    }

    private void deadlockError() {
        this.view.deadlockError();
    }

    @Override
    public void setSelectedItem(String id) {
        super.setSelectedItem(id);
        this.showPerspective(this.itemSelected);
    }

    @Override
    public void onItemClicked(NavItem navItem) {
        super.onItemClicked(navItem);
        this.showPerspective(navItem);
    }

    private void onPerspectiveChanged(@Observes PluginSaved event) {
        Plugin plugin = event.getPlugin();
        String pluginName = plugin.getName();
        String selectedPerspectiveId = this.perspectivePluginManager.getRuntimePerspectiveId(this.itemSelected);
        if (selectedPerspectiveId != null && selectedPerspectiveId.equals(pluginName)) {
            this.showPerspective(this.itemSelected);
        }
    }

    public static interface View
    extends NavWidgetView<NavTabListWidget> {
        public void showContent(IsWidget var1);

        public void deadlockError();
    }
}

