/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.BaseNavWidgetView;
import org.dashbuilder.client.navigation.widget.NavTabListWidget;
import org.dashbuilder.common.client.widgets.AlertBox;
import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class NavTabListWidgetView
extends BaseNavWidgetView<NavTabListWidget>
implements NavTabListWidget.View {
    @Inject
    @DataField
    Div mainDiv;
    @Inject
    @DataField
    Div tabsDiv;
    @Inject
    @DataField
    UnorderedList tabList;
    @Inject
    @DataField
    Div tabContent;
    NavTabListWidget presenter;
    AlertBox alertBox;

    @Inject
    public NavTabListWidgetView(AlertBox alertBox) {
        this.alertBox = alertBox;
        alertBox.setLevel(AlertBox.Level.WARNING);
        alertBox.setCloseEnabled(false);
        CSSStyleDeclaration style = alertBox.getElement().getStyle();
        style.setProperty("width", "30%");
        style.setProperty("margin", "10px");
    }

    public void init(NavTabListWidget presenter) {
        this.presenter = presenter;
        this.navWidget = this.tabList;
    }

    @Override
    public void setActive(boolean active) {
    }

    @Override
    public void addDivider() {
    }

    @Override
    public void showContent(IsWidget widget) {
        DOMUtil.removeAllChildren((Node)this.mainDiv);
        this.mainDiv.appendChild((Node)this.tabsDiv);
        DOMUtil.removeAllChildren((Node)this.tabContent);
        super.appendWidgetToElement((HTMLElement)this.tabContent, widget);
    }

    @Override
    public void errorNavItemsEmpty() {
        DOMUtil.removeAllChildren((Node)this.mainDiv);
        this.alertBox.setMessage(NavigationConstants.INSTANCE.navTabListDragComponentEmptyError());
        this.mainDiv.appendChild((Node)this.alertBox.getElement());
    }

    @Override
    public void deadlockError() {
        DOMUtil.removeAllChildren((Node)this.tabContent);
        this.alertBox.setMessage(NavigationConstants.INSTANCE.navTabListDragComponentDeadlockError());
        this.tabContent.appendChild((Node)this.alertBox.getElement());
    }
}

