/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Stack;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.BaseNavWidget;
import org.dashbuilder.client.navigation.widget.NavItemTileWidget;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.ActivityResourceType;

@Dependent
public class NavTilesWidget
extends BaseNavWidget {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    PlaceManager placeManager;
    SyncBeanManager beanManager;
    String currentPerspectiveId = null;
    Stack<NavItem> navItemStack = new Stack();

    @Inject
    public NavTilesWidget(View view, NavigationManager navigationManager, PerspectivePluginManager perspectivePluginManager, PlaceManager placeManager, SyncBeanManager beanManager) {
        super(view, navigationManager);
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        this.placeManager = placeManager;
        this.beanManager = beanManager;
    }

    public Stack<NavItem> getNavItemStack() {
        return this.navItemStack;
    }

    @Override
    public void show(NavGroup navGroup) {
        this.show(navGroup, true);
    }

    @Override
    public void show(List<NavItem> itemList) {
        this.currentPerspectiveId = null;
        super.show(itemList);
    }

    public void show(NavGroup navGroup, boolean clearBreadcrumb) {
        if (clearBreadcrumb) {
            this.navItemStack.clear();
            this.updateBreadcrumb();
        }
        this.currentPerspectiveId = null;
        super.show(navGroup);
    }

    @Override
    protected void showItem(NavItem navItem) {
        NavItemTileWidget tileWidget = (NavItemTileWidget)this.beanManager.lookupBean(NavItemTileWidget.class, new Annotation[0]).getInstance();
        tileWidget.setOnClick(() -> this.openItem(navItem));
        tileWidget.show(navItem);
        this.view.addTileWidget(tileWidget);
    }

    @Override
    protected void showGroup(NavGroup navGroup) {
        this.showItem((NavItem)navGroup);
    }

    public void openItem(NavItem navItem) {
        NavGroup parent = navItem.getParent();
        if (this.navItemStack.isEmpty()) {
            if (parent != null) {
                this.navItemStack.add((NavItem)parent);
                this.navItemStack.add(navItem);
            }
        } else {
            this.navItemStack.add(navItem);
        }
        this.updateBreadcrumb();
        if (navItem instanceof NavGroup) {
            this.show((NavGroup)navItem, false);
        } else {
            NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)navItem);
            String resourceId = navCtx.getResourceId();
            if (resourceId != null && ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) {
                if (this.perspectivePluginManager.isRuntimePerspective(resourceId)) {
                    this.openPerspective(resourceId);
                } else {
                    this.placeManager.goTo(resourceId);
                }
            }
        }
    }

    protected void openPerspective(String id) {
        this.currentPerspectiveId = id;
        this.perspectivePluginManager.buildPerspectiveWidget(id, (ParameterizedCommand<IsWidget>)((ParameterizedCommand)this::showWidget), this::deadlockError);
    }

    public void showWidget(IsWidget widget) {
        this.view.showTileContent(widget);
    }

    private void deadlockError() {
        this.view.deadlockError();
    }

    protected void updateBreadcrumb() {
        this.view.clearBreadcrumb();
        for (int i = 0; i < this.navItemStack.size(); ++i) {
            NavItem navItem = (NavItem)this.navItemStack.get(i);
            if (i == this.navItemStack.size() - 1) {
                this.view.addBreadcrumbItem(navItem.getName());
                continue;
            }
            this.view.addBreadcrumbItem(navItem.getName(), () -> this.gotoBreadcrumbItem(navItem));
        }
    }

    public void gotoBreadcrumbItem(NavItem navItem) {
        while (this.navItemStack.peek() != navItem) {
            this.navItemStack.pop();
        }
        if (!this.navItemStack.isEmpty()) {
            this.navItemStack.pop();
        }
        this.openItem(navItem);
    }

    private void onPerspectiveChanged(@Observes PluginSaved event) {
        if (this.currentPerspectiveId != null && event.getPlugin().getName().equals(this.currentPerspectiveId)) {
            this.openPerspective(this.currentPerspectiveId);
        }
    }

    public static interface View
    extends NavWidgetView<NavTilesWidget> {
        public void addTileWidget(IsElement var1);

        public void showTileContent(IsWidget var1);

        public void clearBreadcrumb();

        public void addBreadcrumbItem(String var1);

        public void addBreadcrumbItem(String var1, Command var2);

        public void deadlockError();
    }
}

