/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.NavItemEditor;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorActivity;
import org.uberfire.mvp.Command;

@Dependent
public class NavTreeEditor
implements IsWidget {
    public static final NavigationConstants i18n = NavigationConstants.INSTANCE;
    View view;
    SyncBeanManager beanManager;
    PerspectiveTreeProvider perspectiveTreeProvider;
    NavTree navTree;
    NavTree navTreeBackup;
    boolean newDividerEnabled = true;
    boolean newGroupEnabled = true;
    boolean newPerspectiveEnabled = true;
    boolean gotoPerspectiveEnabled = true;
    boolean onlyRuntimePerspectives = false;
    int maxLevels = -1;
    Command onChangeCommand;
    String inCreationId;
    String literalGroup = "Group";
    String literalPerspective = "Perspective";
    String literalDivider = "Divider";
    Optional<NavItemEditor> currentlyEditedItem = Optional.empty();
    Map<String, Integer> navItemMaxLevelsMap = new HashMap<String, Integer>();
    Map<String, Boolean> navItemNewPerspectiveFlagMap = new HashMap<String, Boolean>();

    @Inject
    public NavTreeEditor(View view, SyncBeanManager beanManager, PerspectiveTreeProvider perspectiveTreeProvider) {
        this.view = view;
        this.beanManager = beanManager;
        this.perspectiveTreeProvider = perspectiveTreeProvider;
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public NavTree getNavTree() {
        return this.navTree;
    }

    public void setLiteralGroup(String literalGroup) {
        this.literalGroup = literalGroup;
    }

    public void setLiteralPerspective(String literalPerspective) {
        this.literalPerspective = literalPerspective;
    }

    public void setLiteralDivider(String literalDivider) {
        this.literalDivider = literalDivider;
    }

    public boolean isNewDividerEnabled() {
        return this.newDividerEnabled;
    }

    public void setNewDividerEnabled(boolean newDividerEnabled) {
        this.newDividerEnabled = newDividerEnabled;
    }

    public boolean isNewGroupEnabled() {
        return this.newGroupEnabled;
    }

    public void setNewGroupEnabled(boolean newGroupEnabled) {
        this.newGroupEnabled = newGroupEnabled;
    }

    public boolean isNewPerspectiveEnabled() {
        return this.newPerspectiveEnabled;
    }

    public boolean isNewPerspectiveEnabled(String navItemId) {
        if (this.navItemNewPerspectiveFlagMap.containsKey(navItemId)) {
            return this.navItemNewPerspectiveFlagMap.get(navItemId);
        }
        return this.newPerspectiveEnabled;
    }

    public void setNewPerspectiveEnabled(String navItemId, boolean newPerspectiveEnabled) {
        this.navItemNewPerspectiveFlagMap.put(navItemId, newPerspectiveEnabled);
    }

    public void setNewPerspectiveEnabled(boolean newPerspectiveEnabled) {
        this.newPerspectiveEnabled = newPerspectiveEnabled;
    }

    public boolean isGotoPerspectiveEnabled() {
        return this.gotoPerspectiveEnabled;
    }

    public void setGotoPerspectiveEnabled(boolean gotoPerspectiveEnabled) {
        this.gotoPerspectiveEnabled = gotoPerspectiveEnabled;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public void setMaxLevels(String navItemId, int maxLevels) {
        this.navItemMaxLevelsMap.put(navItemId, maxLevels);
    }

    public int getMaxLevels(String navItemId) {
        if (!this.navItemMaxLevelsMap.containsKey(navItemId)) {
            return -1;
        }
        return this.navItemMaxLevelsMap.get(navItemId);
    }

    public void setMaxLevels(int maxLevels) {
        this.maxLevels = maxLevels;
    }

    public boolean isOnlyRuntimePerspectives() {
        return this.onlyRuntimePerspectives;
    }

    public void setOnlyRuntimePerspectives(boolean onlyRuntimePerspectives) {
        this.onlyRuntimePerspectives = onlyRuntimePerspectives;
    }

    public void setOnChangeCommand(Command onChangeCommand) {
        this.onChangeCommand = onChangeCommand;
    }

    public void edit(NavTree navTree) {
        this.navTree = navTree.cloneTree();
        this.navTreeBackup = navTree.cloneTree();
        this.inCreationId = null;
        this.currentlyEditedItem = Optional.empty();
        this._edit(this.navTree);
    }

    private void _edit(NavTree navTree) {
        this.view.clear();
        this._edit(navTree.getRootItems(), this.maxLevels);
    }

    private void _edit(List<NavItem> navItems, int maxDefault) {
        for (int i = 0; i < navItems.size(); ++i) {
            NavItem navItem = navItems.get(i);
            int max = this.getMaxLevels(navItem.getId());
            max = max > 0 ? max : maxDefault;
            NavItemEditor navItemEditor = this.createNavItemEditor(navItem, i == 0, i == navItems.size() - 1, max <= 0 || max > 0, max <= 0 || max > 1);
            this.view.addItemEditor(navItemEditor);
            if (!(navItem instanceof NavGroup)) continue;
            NavGroup subGroup = (NavGroup)navItem;
            this.view.goOneLevelDown();
            this._edit(subGroup.getChildren(), max == 1 ? 1 : max - 1);
            this.view.goOneLevelUp();
        }
    }

    public NavItemEditor createNavItemEditor(NavItem navItem, boolean isFirst, boolean isLast, boolean childrenAllowed, boolean subGroupsAllowed) {
        NavItemEditor navItemEditor = (NavItemEditor)this.beanManager.lookupBean(NavItemEditor.class, new Annotation[0]).newInstance();
        navItemEditor.setLiteralGroup(this.literalGroup);
        navItemEditor.setLiteralPerspective(this.literalPerspective);
        navItemEditor.setLiteralDivider(this.literalDivider);
        navItemEditor.setOnUpdateCommand(() -> this.onChangeItem(navItem, navItemEditor.getNavItem()));
        navItemEditor.setOnDeleteCommand(() -> this.onDeleteItem(navItem));
        navItemEditor.setOnMoveFirstCommand(() -> this.onMoveFirstItem(navItem));
        navItemEditor.setOnMoveLastCommand(() -> this.onMoveLastItem(navItem));
        navItemEditor.setOnMoveUpCommand(() -> this.onMoveUpItem(navItem));
        navItemEditor.setOnMoveDownCommand(() -> this.onMoveDownItem(navItem));
        navItemEditor.setOnNewSubgroupCommand(() -> this.onNewSubGroup((NavGroup)navItem));
        navItemEditor.setOnNewPerspectiveCommand(() -> this.onNewPerspective((NavGroup)navItem));
        navItemEditor.setOnNewDividerCommand(() -> this.onNewDivider((NavGroup)navItem));
        navItemEditor.setOnEditStartedCommand(() -> this.onItemEditStarted(navItemEditor));
        navItemEditor.setOnEditFinishedCommand(() -> this.onItemEditFinished());
        navItemEditor.setOnEditCancelledCommand(() -> this.onItemEditCancelled());
        navItemEditor.setMoveUpEnabled(!isFirst);
        navItemEditor.setMoveDownEnabled(!isLast);
        navItemEditor.setNewGroupEnabled(this.newGroupEnabled && subGroupsAllowed);
        navItemEditor.setNewDividerEnabled(this.newDividerEnabled && childrenAllowed);
        navItemEditor.setNewPerspectiveEnabled(this.isNewPerspectiveEnabled(navItem.getId()) && childrenAllowed);
        navItemEditor.setGotoPerspectiveEnabled(this.gotoPerspectiveEnabled);
        navItemEditor.setVisiblePerspectiveIds(this.getPerspectiveIds(true));
        navItemEditor.setHiddenPerspectiveIds(this.getPerspectiveIds(false));
        navItemEditor.setPerspectiveNameProvider(arg_0 -> ((PerspectiveTreeProvider)this.perspectiveTreeProvider).getPerspectiveName(arg_0));
        navItemEditor.edit(navItem);
        if (this.inCreationId != null && this.inCreationId.equals(navItem.getId())) {
            this.inCreationId = null;
            navItemEditor.onItemEdit();
        }
        return navItemEditor;
    }

    public NavItemEditor getCurrentlyEditedItem() {
        return this.currentlyEditedItem.isPresent() ? this.currentlyEditedItem.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPerspectiveIds(boolean visible) {
        HashSet<String> result = visible ? new HashSet<String>() : new HashSet(this.perspectiveTreeProvider.getPerspectiveIdsExcluded());
        for (SyncBeanDef beanDef : this.beanManager.lookupBeans(PerspectiveActivity.class)) {
            PerspectiveActivity p = (PerspectiveActivity)beanDef.getInstance();
            try {
                String id = p.getIdentifier();
                boolean runtime = p instanceof PerspectiveEditorActivity;
                if (visible && !this.perspectiveTreeProvider.getPerspectiveIdsExcluded().contains(id) && (!this.onlyRuntimePerspectives || this.onlyRuntimePerspectives && runtime)) {
                    result.add(p.getIdentifier());
                }
                if (visible || !this.onlyRuntimePerspectives || runtime) continue;
                result.add(p.getIdentifier());
            }
            finally {
                this.beanManager.destroyBean((Object)p);
            }
        }
        return result;
    }

    private void onNewSubGroup(NavGroup navGroup) {
        this.inCreationId = "group_" + this.view.generateId();
        String name = i18n.newItemName(this.literalGroup);
        this.navTree.addGroup(this.inCreationId, name, null, navGroup.getId(), true);
        this.showChanges();
    }

    private void onNewPerspective(NavGroup navGroup) {
        this.inCreationId = "perspective_" + this.view.generateId();
        String name = i18n.newItemName(this.literalPerspective);
        this.navTree.addItem(this.inCreationId, name, null, navGroup.getId(), true, NavWorkbenchCtx.perspective((String)"HomePerspective").toString());
        this.showChanges();
    }

    private void onNewDivider(NavGroup navGroup) {
        this.navTree.addDivider(navGroup.getId(), true);
        this.showChanges();
    }

    private void onChangeItem(NavItem oldItem, NavItem newItem) {
        this.navTree.setItemName(oldItem.getId(), newItem.getName());
        this.navTree.setItemDescription(oldItem.getId(), newItem.getDescription());
        this.navTree.setItemContext(oldItem.getId(), newItem.getContext());
        this.view.setChangedFlag(true);
    }

    void onItemEditStarted(NavItemEditor newEditor) {
        this.currentlyEditedItem.ifPresent(NavItemEditor::cancelEdition);
        this.currentlyEditedItem = Optional.of(newEditor);
    }

    void onItemEditFinished() {
        this.currentlyEditedItem = Optional.empty();
    }

    void onItemEditCancelled() {
        this.currentlyEditedItem = Optional.empty();
    }

    private void onDeleteItem(NavItem navItem) {
        this.navTree.deleteItem(navItem.getId());
        this.showChanges();
    }

    private void onMoveUpItem(NavItem navItem) {
        this.navTree.moveItemUp(navItem.getId());
        this.showChanges();
    }

    private void onMoveDownItem(NavItem navItem) {
        this.navTree.moveItemDown(navItem.getId());
        this.showChanges();
    }

    private void onMoveFirstItem(NavItem navItem) {
        this.navTree.moveItemFirst(navItem.getId());
        this.showChanges();
    }

    private void onMoveLastItem(NavItem navItem) {
        this.navTree.moveItemLast(navItem.getId());
        this.showChanges();
    }

    private void showChanges() {
        this._edit(this.navTree);
        this.view.setChangedFlag(true);
    }

    void onSaveClicked() {
        this.edit(this.navTree);
        if (this.onChangeCommand != null) {
            this.onChangeCommand.execute();
        }
    }

    void onCancelClicked() {
        this.edit(this.navTreeBackup);
    }

    public static interface View
    extends UberView<NavTreeEditor> {
        public void clear();

        public void setChangedFlag(boolean var1);

        public void goOneLevelDown();

        public void goOneLevelUp();

        public void addItemEditor(NavItemEditor var1);

        public String generateId();
    }
}

