/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.core.client.Duration;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import java.util.Stack;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.NavItemEditor;
import org.dashbuilder.client.navigation.widget.NavTreeEditor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class NavTreeEditorView
extends Composite
implements NavTreeEditor.View {
    @Inject
    @DataField
    Div treeDiv;
    @Inject
    @DataField
    Div alertDiv;
    @Inject
    @DataField
    Span alertMessage;
    @Inject
    @DataField
    Button saveButton;
    @Inject
    @DataField
    Button cancelButton;
    NavigationConstants i18n = NavigationConstants.INSTANCE;
    NavTreeEditor presenter;
    Stack<Node> itemStack = new Stack();
    Node currentItem = null;

    public void init(NavTreeEditor presenter) {
        this.presenter = presenter;
        this.alertMessage.setTextContent(this.i18n.saveChanges());
        this.saveButton.setTextContent(this.i18n.save());
        this.cancelButton.setTextContent(this.i18n.cancel());
        this.clear();
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((Node)this.treeDiv);
        this.currentItem = this.treeDiv;
        this.itemStack.clear();
        this.setChangedFlag(false);
    }

    @Override
    public void setChangedFlag(boolean on) {
        if (on) {
            this.alertDiv.getStyle().removeProperty("display");
        } else {
            this.alertDiv.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void goOneLevelDown() {
        this.itemStack.push(this.currentItem);
        this.currentItem = null;
    }

    @Override
    public void goOneLevelUp() {
        if (!this.itemStack.isEmpty()) {
            this.currentItem = this.itemStack.pop();
        }
    }

    @Override
    public void addItemEditor(NavItemEditor navItemEditor) {
        Element el = navItemEditor.asWidget().getElement();
        int margin = this.itemStack.size() * 15;
        el.getStyle().setMarginLeft((double)margin, Style.Unit.PX);
        this.treeDiv.appendChild((Node)el);
    }

    @Override
    public String generateId() {
        return Double.toString(Duration.currentTimeMillis());
    }

    @EventHandler(value={"saveButton"})
    public void onSaveClicked(ClickEvent event) {
        this.presenter.onSaveClicked();
    }

    @EventHandler(value={"cancelButton"})
    public void onCancelClicked(ClickEvent event) {
        this.presenter.onCancelClicked();
    }
}

