/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.plugin;

import java.util.Collections;
import java.util.List;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.PerspectivePluginsChangedEvent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.navigation.service.PerspectivePluginServices;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectivePluginManagerTest {
    private static final String PERSPECTIVE_ID = "Persp1";
    private static final NavTree TEST_NAV_TREE = new NavTreeBuilder().item("Persp1", "name1", "description1", true, (NavItemContext)NavWorkbenchCtx.perspective((String)"Persp1")).build();
    @Mock
    private NavigationManager navigationManager;
    @Mock
    private ClientTypeRegistry clientTypeRegistry;
    @Mock
    private PerspectivePluginServices pluginServices;
    @Mock
    private Event<PerspectivePluginsChangedEvent> perspectiveChangedEvent;
    private PluginAdded pluginAddedEvent;
    private PluginSaved pluginSavedEvent;
    private PluginRenamed pluginRenamedEvent;
    private PluginDeleted pluginDeletedEvent;
    private Plugin perspectivePlugin;
    private Plugin perspectiveRenamedPlugin;
    private PerspectivePluginManager testedPluginManager;

    @Before
    public void setUp() {
        Mockito.when((Object)this.clientTypeRegistry.resolve((Path)Matchers.any())).thenReturn((Object)new PerspectiveLayoutPluginResourceType());
        this.perspectivePlugin = new Plugin(PERSPECTIVE_ID, PluginType.PERSPECTIVE_LAYOUT, null);
        this.perspectiveRenamedPlugin = new Plugin("newName", PluginType.PERSPECTIVE_LAYOUT, null);
        this.pluginAddedEvent = new PluginAdded(this.perspectivePlugin, null);
        this.pluginSavedEvent = new PluginSaved(this.perspectivePlugin, null);
        this.pluginRenamedEvent = new PluginRenamed(PERSPECTIVE_ID, this.perspectiveRenamedPlugin, null);
        this.pluginDeletedEvent = new PluginDeleted(this.perspectivePlugin, null);
        Mockito.when((Object)this.pluginServices.listPlugins()).thenReturn(Collections.emptyList());
        this.testedPluginManager = new PerspectivePluginManager(this.clientTypeRegistry, null, this.navigationManager, (Caller)new CallerMock((Object)this.pluginServices), this.perspectiveChangedEvent);
        this.testedPluginManager.getPerspectivePlugins(plugins -> {});
    }

    @Test
    public void testPluginAdded() {
        this.testedPluginManager.getPerspectivePlugins(plugins -> Assertions.assertThat((Iterable)plugins).isEmpty());
        this.testedPluginManager.onPlugInAdded(this.pluginAddedEvent);
        ((Event)Mockito.verify(this.perspectiveChangedEvent)).fire(Matchers.anyObject());
        this.testedPluginManager.getPerspectivePlugins(plugins -> {
            IterableAssert cfr_ignored_0 = (IterableAssert)Assertions.assertThat((Iterable)plugins).hasSize(1);
        });
    }

    @Test
    public void testPluginSaved() {
        Assertions.assertThat((boolean)this.testedPluginManager.existsPerspectivePlugin(PERSPECTIVE_ID)).isFalse();
        this.testedPluginManager.onPlugInSaved(this.pluginSavedEvent);
        ((Event)Mockito.verify(this.perspectiveChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.anyObject());
        Assertions.assertThat((boolean)this.testedPluginManager.existsPerspectivePlugin(PERSPECTIVE_ID)).isTrue();
    }

    @Test
    public void testPluginRenamed() {
        NavTree tree = TEST_NAV_TREE.cloneTree();
        List items = tree.searchItems((NavItemContext)NavWorkbenchCtx.perspective((String)PERSPECTIVE_ID));
        Assertions.assertThat((String)((NavItem)items.get(0)).getName()).isEqualTo((Object)"name1");
        Assertions.assertThat((String)((NavItem)items.get(0)).getContext()).contains(new CharSequence[]{"resourceId=Persp1"});
        Mockito.when((Object)this.navigationManager.getNavTree()).thenReturn((Object)tree);
        this.testedPluginManager.onPlugInRenamed(this.pluginRenamedEvent);
        Assertions.assertThat((List)tree.searchItems((NavItemContext)NavWorkbenchCtx.perspective((String)PERSPECTIVE_ID))).isEmpty();
        Assertions.assertThat((String)((NavItem)tree.searchItems((NavItemContext)NavWorkbenchCtx.perspective((String)this.perspectiveRenamedPlugin.getName())).get(0)).getContext()).contains(new CharSequence[]{"resourceId=" + this.perspectiveRenamedPlugin.getName()});
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((NavigationManager)Mockito.verify((Object)this.navigationManager, (VerificationMode)Mockito.times((int)1))).saveNavTree((NavTree)Matchers.anyObject(), (Command)argumentCaptor.capture());
        ((Event)Mockito.verify(this.perspectiveChangedEvent)).fire(Matchers.anyObject());
    }

    @Test
    public void testPluginDeleted() {
        NavTree testTree = TEST_NAV_TREE.cloneTree();
        Assertions.assertThat((Object)testTree.getItemById(PERSPECTIVE_ID)).isNotNull();
        Mockito.when((Object)this.navigationManager.getNavTree()).thenReturn((Object)testTree);
        this.testedPluginManager.onPlugInDeleted(this.pluginDeletedEvent);
        Assertions.assertThat((Object)testTree.getItemById(PERSPECTIVE_ID)).isNull();
        ((NavigationManager)Mockito.verify((Object)this.navigationManager)).saveNavTree((NavTree)Matchers.anyObject(), (Command)Matchers.eq(null));
        ((Event)Mockito.verify(this.perspectiveChangedEvent)).fire(Matchers.anyObject());
    }
}

