/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavItemEditCancelledEvent;
import org.dashbuilder.client.navigation.event.NavItemEditStartedEvent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.editor.NavItemDefaultEditor;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditor;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditorSettings;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditorView;
import org.dashbuilder.client.navigation.widget.editor.TargetPerspectiveEditor;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;

@Dependent
public class NavTreeEditor
extends NavItemEditor {
    public static final NavigationConstants i18n = NavigationConstants.INSTANCE;
    public static final String ROOT_GROUP_ID = "NavTreeEditorRootGroupId";
    NavTreeEditorView view;
    NavigationManager navigationManager;
    NavTree navTree;
    Command onSaveCommand;
    Optional<NavItemEditor> currentlyEditedItem = Optional.empty();

    @Inject
    public NavTreeEditor(NavTreeEditorView view, NavigationManager navigationManager, SyncBeanManager beanManager, PlaceManager placeManager, PerspectiveTreeProvider perspectiveTreeProvider, TargetPerspectiveEditor targetPerspectiveEditor, PerspectivePluginManager perspectivePluginManager, Event<NavItemEditStartedEvent> navItemEditStartedEvent, Event<NavItemEditCancelledEvent> navItemEditCancelledEvent) {
        super(view, beanManager, placeManager, perspectiveTreeProvider, targetPerspectiveEditor, perspectivePluginManager, navItemEditStartedEvent, navItemEditCancelledEvent);
        this.view = view;
        this.navigationManager = navigationManager;
        this.view.init(this);
        super.setChildEditorClass(NavItemDefaultEditor.class);
    }

    public void setOnSaveCommand(Command onSaveCommand) {
        this.onSaveCommand = onSaveCommand;
    }

    @Override
    public String getGroupLiteral() {
        return "Tree";
    }

    public void setMaximized(boolean maximized) {
        this.view.setMaximized(maximized);
    }

    public NavTree getNavTree() {
        return this.navTree;
    }

    public void edit(NavTree navTree) {
        this.navTree = navTree.cloneTree();
        this.currentlyEditedItem = Optional.empty();
        this.view.setChangedFlag(false);
        NavGroup rootGroup = NavFactory.get().createNavGroup(navTree);
        rootGroup.setId(ROOT_GROUP_ID);
        this.getSettings().setNewDividerEnabled(ROOT_GROUP_ID, false);
        this.getSettings().setNewPerspectiveEnabled(ROOT_GROUP_ID, false);
        super.edit((NavItem)rootGroup);
        super.expand();
    }

    @Override
    void onItemUpdated() {
        this.view.setChangedFlag(true);
        this.currentlyEditedItem = Optional.empty();
        super.onItemUpdated();
    }

    void onNewTreeClicked() {
        this.newGroup();
    }

    void onSaveClicked() {
        NavGroup rootGroup = (NavGroup)super.getNavItem();
        NavTree modifiedTree = NavFactory.get().createNavTree((NavItem)rootGroup);
        this.navigationManager.saveNavTree(modifiedTree, () -> {
            this.navTree = modifiedTree;
            this.view.setChangedFlag(false);
            this.currentlyEditedItem = Optional.empty();
            if (this.onSaveCommand != null) {
                this.onSaveCommand.execute();
            }
        });
    }

    void onCancelClicked() {
        this.edit(this.navTree);
    }

    void onItemEditStarted(@Observes NavItemEditStartedEvent event) {
        this.currentlyEditedItem.filter(e -> !e.equals(event.getNavItemEditor())).ifPresent(NavItemEditor::cancelEdition);
        this.currentlyEditedItem = Optional.of(event.getNavItemEditor());
    }

    void onItemEditCancelled(@Observes NavItemEditCancelledEvent event) {
        this.currentlyEditedItem = Optional.empty();
    }

    NavItemEditor getCurrentlyEditedItem() {
        return this.currentlyEditedItem.isPresent() ? this.currentlyEditedItem.get() : null;
    }

    public NavItemEditorSettings setMaxLevels(String navItemId, int maxLevels) {
        return this.getSettings().setMaxLevels(navItemId, maxLevels);
    }

    public NavItemEditorSettings.Flags setNewGroupEnabled(String navItemId, boolean enabled) {
        return this.getSettings().setNewGroupEnabled(navItemId, enabled);
    }

    public NavItemEditorSettings.Flags setNewPerspectiveEnabled(String navItemId, boolean enabled) {
        return this.getSettings().setNewPerspectiveEnabled(navItemId, enabled);
    }

    public NavItemEditorSettings.Flags setNewDividerEnabled(String navItemId, boolean enabled) {
        return this.getSettings().setNewDividerEnabled(navItemId, enabled);
    }

    public NavItemEditorSettings.Flags setOnlyRuntimePerspectives(String navItemId, boolean enabled) {
        return this.getSettings().setOnlyRuntimePerspectives(navItemId, enabled);
    }

    public NavItemEditorSettings.Flags setPerspectiveContextEnabled(String navItemId, boolean enabled) {
        return this.getSettings().setPerspectiveContextEnabled(navItemId, enabled);
    }

    public static interface View
    extends NavItemEditor.View<NavTreeEditor> {
        public String getTreeLiteralI18n();

        public void setMaximized(boolean var1);

        public void setChangedFlag(boolean var1);
    }
}

