/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.impl;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavItemGotoEvent;
import org.dashbuilder.client.navigation.event.NavTreeChangedEvent;
import org.dashbuilder.client.navigation.event.NavTreeLoadedEvent;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.service.NavigationServices;
import org.dashbuilder.navigation.workbench.NavSecurityController;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class NavigationManagerImpl
implements NavigationManager {
    private Caller<NavigationServices> navServices;
    private Event<NavItemGotoEvent> navItemGotoEvent;
    private Event<NavTreeLoadedEvent> navTreeLoadedEvent;
    private Event<NavTreeChangedEvent> navTreeChangedEvent;
    private NavSecurityController navController;
    private NavTree navTree;
    private NavTree defaultNavTree;

    @Inject
    public NavigationManagerImpl(Caller<NavigationServices> navServices, NavSecurityController navController, Event<NavTreeLoadedEvent> navTreeLoadedEvent, Event<NavTreeChangedEvent> navTreeChangedEvent, Event<NavItemGotoEvent> navItemGotoEvent) {
        this.navServices = navServices;
        this.navController = navController;
        this.navTreeLoadedEvent = navTreeLoadedEvent;
        this.navTreeChangedEvent = navTreeChangedEvent;
        this.navItemGotoEvent = navItemGotoEvent;
    }

    @Override
    public void init(Command afterInit) {
        ((NavigationServices)this.navServices.call(n -> {
            this.navTree = n;
            if (afterInit != null) {
                afterInit.execute();
            }
            this.navTreeLoadedEvent.fire((Object)new NavTreeLoadedEvent(this.getNavTree()));
        })).loadNavTree();
    }

    @Override
    public NavTree getDefaultNavTree() {
        return this.defaultNavTree;
    }

    @Override
    public void setDefaultNavTree(NavTree defaultNavTree) {
        this.defaultNavTree = defaultNavTree;
    }

    @Override
    public NavTree getNavTree() {
        return !this.hasNavTree() ? this.defaultNavTree : this.navTree;
    }

    @Override
    public boolean hasNavTree() {
        return Optional.ofNullable(this.navTree).isPresent();
    }

    @Override
    public void saveNavTree(NavTree newTree, Command afterSave) {
        ((NavigationServices)this.navServices.call(v -> {
            this.navTree = newTree;
            this.navTreeChangedEvent.fire((Object)new NavTreeChangedEvent(newTree));
            if (afterSave != null) {
                afterSave.execute();
            }
        })).saveNavTree(newTree);
    }

    @Override
    public NavTree secure(NavTree navTree, boolean removeEmptyGroups) {
        return this.navController.secure(navTree, removeEmptyGroups);
    }

    @Override
    public void secure(List<NavItem> itemList, boolean removeEmptyGroups) {
        this.navController.secure(itemList, removeEmptyGroups);
    }

    @Override
    public void navItemClicked(NavItem navItem) {
        if (this.navController.canRead(navItem)) {
            this.navItemGotoEvent.fire((Object)new NavItemGotoEvent(navItem));
        }
    }
}

