/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.BaseNavWidgetView;
import org.dashbuilder.client.navigation.widget.NavTilesWidget;
import org.dashbuilder.common.client.widgets.AlertBox;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.OrderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class NavTilesWidgetView
extends BaseNavWidgetView<NavTilesWidget>
implements NavTilesWidget.View {
    @Inject
    @DataField
    Div mainDiv;
    @Inject
    @DataField
    Div contentDiv;
    @Inject
    @DataField
    Div tilesDiv;
    @Inject
    @DataField(value="breadcrumb")
    OrderedList breadcrumb;
    NavTilesWidget presenter;
    AlertBox alertBox;

    @Inject
    public NavTilesWidgetView(AlertBox alertBox) {
        this.alertBox = alertBox;
        alertBox.setLevel(AlertBox.Level.WARNING);
        alertBox.setCloseEnabled(false);
        alertBox.getElement().getStyle().setProperty("width", "96%");
    }

    public void init(NavTilesWidget presenter) {
        this.presenter = presenter;
        this.navWidget = this.tilesDiv;
    }

    @Override
    public void addDivider() {
    }

    @Override
    public void addTileWidget(IsElement tileWidget) {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.mainDiv);
        this.mainDiv.appendChild((org.jboss.errai.common.client.dom.Node)this.contentDiv);
        this.tilesDiv.appendChild((org.jboss.errai.common.client.dom.Node)tileWidget.getElement());
    }

    @Override
    public void showTileContent(IsWidget tileContent) {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.tilesDiv);
        super.appendWidgetToElement((HTMLElement)this.tilesDiv, tileContent);
    }

    @Override
    public void errorNavItemsEmpty() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.mainDiv);
        this.alertBox.setMessage(NavigationConstants.INSTANCE.navGroupEmptyError());
        this.mainDiv.appendChild((org.jboss.errai.common.client.dom.Node)this.alertBox.getElement());
    }

    @Override
    public void errorNavGroupNotFound() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.mainDiv);
        this.alertBox.setMessage(NavigationConstants.INSTANCE.navGroupNotFound());
        this.mainDiv.appendChild((org.jboss.errai.common.client.dom.Node)this.alertBox.getElement());
    }

    @Override
    public void infiniteRecursionError(String cause) {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.tilesDiv);
        this.alertBox.setMessage(NavigationConstants.INSTANCE.navTilesDragComponentInfiniteRecursion() + cause);
        this.tilesDiv.appendChild((org.jboss.errai.common.client.dom.Node)this.alertBox.getElement());
    }

    @Override
    public void clearBreadcrumb() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.breadcrumb);
    }

    @Override
    public void addBreadcrumbItem(String navItemName) {
        this.addBreadcrumbItem(navItemName, null);
    }

    @Override
    public void addBreadcrumbItem(String navItemName, Command onClicked) {
        LIElement li = Document.get().createLIElement();
        this.breadcrumb.appendChild((org.jboss.errai.common.client.dom.Node)li);
        if (onClicked != null) {
            AnchorElement anchor = Document.get().createAnchorElement();
            anchor.setInnerText(navItemName);
            li.appendChild((Node)anchor);
            li.getStyle().setCursor(Style.Cursor.POINTER);
            Event.sinkEvents((Element)anchor, (int)1);
            Event.setEventListener((Element)anchor, event -> {
                if (1 == event.getTypeInt()) {
                    onClicked.execute();
                }
            });
        } else {
            ((org.jboss.errai.common.client.dom.Node)li).setTextContent(navItemName);
            li.setClassName("active");
        }
    }
}

