/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Stack;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.BaseNavWidget;
import org.dashbuilder.client.navigation.widget.NavItemTileWidget;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.layout.LayoutRecursionIssue;
import org.dashbuilder.navigation.layout.LayoutRecursionIssueI18n;
import org.dashbuilder.navigation.layout.LayoutTemplateContext;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.ActivityResourceType;

@Dependent
public class NavTilesWidget
extends BaseNavWidget {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    PlaceManager placeManager;
    SyncBeanManager beanManager;
    NavItem currentPerspectiveNavItem = null;
    Stack<NavItem> navItemStack = new Stack();

    @Inject
    public NavTilesWidget(View view, NavigationManager navigationManager, PerspectivePluginManager perspectivePluginManager, PlaceManager placeManager, SyncBeanManager beanManager) {
        super(view, navigationManager);
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        this.placeManager = placeManager;
        this.beanManager = beanManager;
    }

    public Stack<NavItem> getNavItemStack() {
        return this.navItemStack;
    }

    @Override
    public void show(NavGroup navGroup) {
        this.show(navGroup, true);
    }

    @Override
    public void show(List<NavItem> itemList) {
        this.currentPerspectiveNavItem = null;
        super.show(itemList);
    }

    public void show(NavGroup navGroup, boolean clearBreadcrumb) {
        if (navGroup == null) {
            this.view.errorNavGroupNotFound();
        } else {
            NavGroup clone = (NavGroup)navGroup.cloneItem();
            clone.setParent(null);
            if (clearBreadcrumb) {
                this.navItemStack.clear();
                this.updateBreadcrumb();
            }
            this.currentPerspectiveNavItem = null;
            super.show(clone);
        }
    }

    @Override
    protected void showItem(NavItem navItem) {
        NavItemTileWidget tileWidget = (NavItemTileWidget)this.beanManager.lookupBean(NavItemTileWidget.class, new Annotation[0]).getInstance();
        tileWidget.setOnClick(() -> this.openItem(navItem));
        tileWidget.show(navItem);
        this.view.addTileWidget(tileWidget);
    }

    @Override
    protected void showGroup(NavGroup navGroup) {
        this.showItem((NavItem)navGroup);
    }

    public void openItem(NavItem navItem) {
        NavGroup parent = navItem.getParent();
        if (this.navItemStack.isEmpty()) {
            if (parent != null) {
                this.navItemStack.add((NavItem)parent);
                this.navItemStack.add(navItem);
            }
        } else {
            this.navItemStack.add(navItem);
        }
        this.updateBreadcrumb();
        if (navItem instanceof NavGroup) {
            this.show((NavGroup)navItem, false);
        } else {
            NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)navItem);
            String resourceId = navCtx.getResourceId();
            if (resourceId != null && ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) {
                if (this.perspectivePluginManager.isRuntimePerspective(resourceId)) {
                    this.openPerspective(navItem);
                } else {
                    this.placeManager.goTo(resourceId);
                }
            }
        }
    }

    protected void openPerspective(NavItem perspectiveItem) {
        NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)perspectiveItem);
        String perspectiveId = navCtx.getResourceId();
        String navRootId = navCtx.getNavGroupId();
        this.currentPerspectiveNavItem = perspectiveItem;
        LayoutTemplateContext layoutCtx = new LayoutTemplateContext(navRootId);
        this.perspectivePluginManager.buildPerspectiveWidget(perspectiveId, layoutCtx, (ParameterizedCommand<IsWidget>)((ParameterizedCommand)this.view::showTileContent), (ParameterizedCommand<LayoutRecursionIssue>)((ParameterizedCommand)this::onInfiniteRecursion));
    }

    public void onInfiniteRecursion(LayoutRecursionIssue issue) {
        String cause = issue.printReport(this.navigationManager.getNavTree(), (LayoutRecursionIssueI18n)this.view);
        this.view.infiniteRecursionError(cause);
    }

    protected void updateBreadcrumb() {
        this.view.clearBreadcrumb();
        for (int i = 0; i < this.navItemStack.size(); ++i) {
            NavItem navItem = (NavItem)this.navItemStack.get(i);
            if (i == this.navItemStack.size() - 1) {
                this.view.addBreadcrumbItem(navItem.getName());
                continue;
            }
            this.view.addBreadcrumbItem(navItem.getName(), () -> this.gotoBreadcrumbItem(navItem));
        }
    }

    public void gotoBreadcrumbItem(NavItem navItem) {
        while (this.navItemStack.peek() != navItem) {
            this.navItemStack.pop();
        }
        if (!this.navItemStack.isEmpty()) {
            this.navItemStack.pop();
        }
        this.openItem(navItem);
    }

    private void onPerspectiveChanged(@Observes PluginSaved event) {
        if (this.currentPerspectiveNavItem != null) {
            NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)this.currentPerspectiveNavItem);
            String perspectiveId = navCtx.getResourceId();
            if (event.getPlugin().getName().equals(perspectiveId)) {
                this.openPerspective(this.currentPerspectiveNavItem);
            }
        }
    }

    public static interface View
    extends NavWidgetView<NavTilesWidget>,
    LayoutRecursionIssueI18n {
        public void addTileWidget(IsElement var1);

        public void showTileContent(IsWidget var1);

        public void clearBreadcrumb();

        public void addBreadcrumbItem(String var1);

        public void addBreadcrumbItem(String var1, Command var2);

        public void infiniteRecursionError(String var1);
    }
}

