/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.BaseNavWidgetView;
import org.dashbuilder.client.navigation.widget.TargetDivNavWidget;
import org.dashbuilder.common.client.widgets.AlertBox;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Window;

public abstract class TargetDivNavWidgetView<T extends TargetDivNavWidget>
extends BaseNavWidgetView<T>
implements TargetDivNavWidget.View<T> {
    AlertBox alertBox;

    public TargetDivNavWidgetView(AlertBox alertBox) {
        this.alertBox = alertBox;
        alertBox.setLevel(AlertBox.Level.WARNING);
        alertBox.setCloseEnabled(false);
        alertBox.getElement().getStyle().setProperty("width", "96%");
    }

    @Override
    public void clearContent(String targetDivId) {
        HTMLElement targetDiv = this.getTargetDiv(targetDivId);
        if (targetDiv != null) {
            DOMUtil.removeAllChildren((Node)targetDiv);
        }
    }

    @Override
    public void showContent(String targetDivId, IsWidget content) {
        HTMLElement targetDiv = this.getTargetDiv(targetDivId);
        if (targetDiv != null) {
            DOMUtil.removeAllChildren((Node)targetDiv);
            Div container = (Div)Window.getDocument().createElement("div");
            container.getStyle().setProperty("overflow", "hidden");
            targetDiv.appendChild((Node)container);
            super.appendWidgetToElement((HTMLElement)container, content);
        } else {
            this.error(NavigationConstants.INSTANCE.navWidgetTargetDivMissing());
        }
    }

    @Override
    public void errorNavGroupNotFound() {
        this.error(NavigationConstants.INSTANCE.navGroupNotFound());
    }

    @Override
    public void errorNavItemsEmpty() {
        this.error(NavigationConstants.INSTANCE.navGroupEmptyError());
    }

    @Override
    public void infiniteRecursionError(String targetDivId, String cause) {
        HTMLElement targetDiv = this.getTargetDiv(targetDivId);
        if (targetDiv != null) {
            DOMUtil.removeAllChildren((Node)targetDiv);
            String message = NavigationConstants.INSTANCE.targetDivIdPerspectiveInfiniteRecursion() + cause;
            this.alertBox.setMessage(message);
            targetDiv.appendChild((Node)this.alertBox.getElement());
        } else {
            this.error(NavigationConstants.INSTANCE.targetDivIdPerspectiveInfiniteRecursion());
        }
    }

    public void error(String message) {
        DOMUtil.removeAllChildren((Node)this.navWidget);
        this.alertBox.setMessage(message);
        this.navWidget.appendChild((Node)this.alertBox.getElement());
    }

    protected Element getLayoutRootElement(Element el) {
        if (el == null) {
            return null;
        }
        String id = el.getAttribute("id");
        if (id != null && (id.equals("mainContainer") || id.equals("layout"))) {
            return el;
        }
        return this.getLayoutRootElement(el.getParentElement());
    }

    public HTMLElement getTargetDiv(String targetDivId) {
        Element layoutRoot;
        HTMLElement targetDiv = null;
        if (targetDivId != null && (layoutRoot = this.getLayoutRootElement(this.navWidget.getParentElement())) != null) {
            targetDiv = (HTMLElement)layoutRoot.querySelector("#" + targetDivId);
        }
        return targetDiv;
    }
}

