/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.dashbuilder.client.navigation.event.NavItemEditCancelledEvent;
import org.dashbuilder.client.navigation.event.NavItemEditStartedEvent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditorSettings;
import org.dashbuilder.client.navigation.widget.editor.TargetPerspectiveEditor;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.layout.LayoutTemplateInfo;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.AbstractWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.model.ActivityResourceType;

public abstract class NavItemEditor
implements IsElement {
    View view;
    SyncBeanManager beanManager;
    PlaceManager placeManager;
    PerspectiveTreeProvider perspectiveTreeProvider;
    TargetPerspectiveEditor targetPerspectiveEditor;
    PerspectivePluginManager perspectivePluginManager;
    Event<NavItemEditStartedEvent> navItemEditStartedEvent;
    Event<NavItemEditCancelledEvent> navItemEditCancelledEvent;
    boolean creationEnabled = false;
    boolean moveUpEnabled = true;
    boolean moveDownEnabled = true;
    boolean editEnabled = false;
    boolean deleteEnabled = false;
    boolean itemNameFromPerspective = false;
    private NavItemEditorSettings settings;
    private Class<? extends NavItemEditor> childEditorClass;
    NavItemEditor parentEditor = null;
    List<NavItemEditor> childEditorList = new ArrayList<NavItemEditor>();
    NavItem navItem = null;
    NavItem navItemBackup = null;
    ItemType itemType = null;
    String perspectiveId = null;
    boolean expanded;
    Command onUpdateCommand;
    Command onCancelCommand;
    Command onMoveUpCommand;
    Command onMoveDownCommand;
    Command onMoveFirstCommand;
    Command onMoveLastCommand;
    Command onDeleteCommand;
    Command onExpandCommand;
    public static final NavigationConstants i18n = NavigationConstants.INSTANCE;

    public NavItemEditor(View view, SyncBeanManager beanManager, PlaceManager placeManager, PerspectiveTreeProvider perspectiveTreeProvider, TargetPerspectiveEditor targetPerspectiveEditor, PerspectivePluginManager perspectivePluginManager, Event<NavItemEditStartedEvent> navItemEditStartedEvent, Event<NavItemEditCancelledEvent> navItemEditCancelledEvent) {
        this.beanManager = beanManager;
        this.placeManager = placeManager;
        this.perspectiveTreeProvider = perspectiveTreeProvider;
        this.targetPerspectiveEditor = targetPerspectiveEditor;
        this.targetPerspectiveEditor.setOnUpdateCommand(this::onTargetPerspectiveUpdated);
        this.perspectivePluginManager = perspectivePluginManager;
        this.navItemEditStartedEvent = navItemEditStartedEvent;
        this.navItemEditCancelledEvent = navItemEditCancelledEvent;
        this.view = view;
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public NavItemEditorSettings getSettings() {
        if (this.settings == null) {
            this.settings = new NavItemEditorSettings();
        }
        return this.settings;
    }

    public void setSettings(NavItemEditorSettings settings) {
        this.settings = settings;
    }

    public Class<? extends NavItemEditor> getChildEditorClass() {
        return this.childEditorClass;
    }

    public void setChildEditorClass(Class<? extends NavItemEditor> childEditorClass) {
        this.childEditorClass = childEditorClass;
    }

    public NavItemEditor getParentEditor() {
        return this.parentEditor;
    }

    public void setParentEditor(NavItemEditor parentEditor) {
        this.parentEditor = parentEditor;
        NavItemEditor rootEditor = this.getRootEditor();
        if (rootEditor != null && rootEditor.getNavItem() instanceof NavGroup) {
            NavGroup rootGroup = (NavGroup)rootEditor.getNavItem();
            this.targetPerspectiveEditor.setNavItemList(rootGroup.getChildren());
        }
    }

    public NavItemEditor getRootEditor() {
        return this.parentEditor == null ? this : this.parentEditor.getRootEditor();
    }

    public int getLevel() {
        if (this.parentEditor == null) {
            return 0;
        }
        return this.parentEditor.getLevel() + 1;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public String getGroupLiteral() {
        return this.settings != null ? this.settings.getLiteralGroup() : "Group";
    }

    public String getNewPerspectiveI18n() {
        String newItemName = this.view.i18nNewItemName(this.getPerspectiveLiteral());
        return newItemName != null ? newItemName : "- New Perspective -";
    }

    public String getPerspectiveLiteral() {
        return this.settings != null ? this.settings.getLiteralPerspective() : "Perspective";
    }

    public String getDividerLiteral() {
        return this.settings != null ? this.settings.getLiteralDivider() : "Divider";
    }

    public boolean isNewGroupEnabled() {
        return (this.settings == null || this.settings.isNewGroupEnabled(this.navItem)) && this.areSubgroupsAllowed();
    }

    public boolean isNewPerspectiveEnabled() {
        return (this.settings == null || this.settings.isNewPerspectiveEnabled(this.navItem)) && this.areChildrenAllowed() && !this.getPerspectiveIds(this.navItem, true).isEmpty();
    }

    public boolean isNewDividerEnabled() {
        return (this.settings == null || this.settings.isNewDividerEnabled(this.navItem)) && this.areChildrenAllowed();
    }

    public boolean isGotoPerspectiveEnabled() {
        return (this.settings == null || this.settings.isGotoPerspectiveEnabled(this.navItem)) && this.perspectiveId != null;
    }

    public boolean isMoveUpEnabled() {
        return this.moveUpEnabled;
    }

    public void setMoveUpEnabled(boolean moveUpEnabled) {
        this.moveUpEnabled = moveUpEnabled;
    }

    public boolean isMoveDownEnabled() {
        return this.moveDownEnabled;
    }

    public void setMoveDownEnabled(boolean moveDownEnabled) {
        this.moveDownEnabled = moveDownEnabled;
    }

    public void setOnUpdateCommand(Command onUpdateCommand) {
        this.onUpdateCommand = onUpdateCommand;
    }

    public void setOnCancelCommand(Command onCancelCommand) {
        this.onCancelCommand = onCancelCommand;
    }

    public void setOnMoveFirstCommand(Command onMoveFirstCommand) {
        this.onMoveFirstCommand = onMoveFirstCommand;
    }

    public void setOnMoveLastCommand(Command onMoveLastCommand) {
        this.onMoveLastCommand = onMoveLastCommand;
    }

    public void setOnMoveUpCommand(Command onMoveUpCommand) {
        this.onMoveUpCommand = onMoveUpCommand;
    }

    public void setOnMoveDownCommand(Command onMoveDownCommand) {
        this.onMoveDownCommand = onMoveDownCommand;
    }

    public void setOnDeleteCommand(Command onDeleteCommand) {
        this.onDeleteCommand = onDeleteCommand;
    }

    public void setOnExpandCommand(Command onExpandCommand) {
        this.onExpandCommand = onExpandCommand;
    }

    public NavItem getNavItem() {
        return this.navItem;
    }

    public void edit(NavItem navItem) {
        this.clear();
        this.navItem = navItem.cloneItem();
        this.navItemBackup = navItem;
        this.doEdit();
    }

    public boolean canBeExpanded() {
        return ItemType.GROUP.equals((Object)this.itemType) && !this.childEditorList.isEmpty();
    }

    public void expand() {
        if (!this.expanded && this.canBeExpanded()) {
            this.expanded = true;
            this.view.setExpanded(this.expanded);
        }
    }

    public void collapse() {
        if (this.expanded && this.canBeExpanded()) {
            this.expanded = false;
            this.view.setExpanded(this.expanded);
        }
    }

    public void expandAll() {
        this.expand();
        this.childEditorList.forEach(NavItemEditor::expandAll);
    }

    public void collapseAll() {
        this.collapse();
        this.childEditorList.forEach(NavItemEditor::collapseAll);
    }

    public void expandOrCollapse() {
        if (this.canBeExpanded()) {
            if (this.expanded) {
                this.collapse();
            } else {
                this.expand();
            }
            if (this.onExpandCommand != null) {
                this.onExpandCommand.execute();
            }
        }
    }

    public void startEdition() {
        if (this.editEnabled) {
            if (this.itemNameFromPerspective) {
                String perspectiveName = this.targetPerspectiveEditor.getPerspectiveName(this.perspectiveId);
                this.view.setItemName(perspectiveName);
            }
            if (this.settings == null || this.settings.isPerspectiveContextEnabled(this.navItem)) {
                this.perspectivePluginManager.getLayoutTemplateInfo(this.perspectiveId, (ParameterizedCommand<LayoutTemplateInfo>)((ParameterizedCommand)info -> {
                    this.targetPerspectiveEditor.setNavGroupEnabled(info != null && info.hasNavigationComponents());
                    this.view.startItemEdition();
                    this.navItemEditStartedEvent.fire((Object)new NavItemEditStartedEvent(this));
                }));
            } else {
                this.targetPerspectiveEditor.setNavGroupEnabled(false);
                this.view.startItemEdition();
                this.navItemEditStartedEvent.fire((Object)new NavItemEditStartedEvent(this));
            }
        }
    }

    public void finishEdition() {
        this.view.finishItemEdition();
        this.childEditorList.forEach(NavItemEditor::finishEdition);
    }

    public void cancelEdition() {
        this.view.finishItemEdition();
        this.edit(this.navItemBackup);
        this.onEditCancelled();
    }

    private void doEdit() {
        NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)this.navItem);
        if (this.navItem.getName() != null) {
            this.view.setItemName(this.navItem.getName());
            String newPerspectiveI18n = this.getNewPerspectiveI18n();
            this.itemNameFromPerspective = newPerspectiveI18n.equals(this.navItem.getName());
        }
        if (this.navItem.getDescription() != null) {
            this.view.setItemDescription(this.navItem.getDescription());
        }
        this.creationEnabled = false;
        this.editEnabled = this.navItem.isModifiable();
        this.deleteEnabled = this.navItem.isModifiable();
        if (this.navItem instanceof NavGroup) {
            this.itemType = ItemType.GROUP;
            this.view.setItemType(this.itemType);
            this.view.setExpandEnabled(false);
            if (this.areChildrenAllowed()) {
                this.view.setExpanded(this.expanded);
                this.creationEnabled = true;
                NavGroup navGroup = (NavGroup)this.navItem;
                this.registerChildren(navGroup);
            }
        } else if (this.navItem instanceof NavDivider) {
            this.itemType = ItemType.DIVIDER;
            this.view.setItemType(this.itemType);
            this.view.setItemName("--------------");
            this.editEnabled = false;
        } else if (navCtx.getResourceId() != null && ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) {
            Set<String> visiblePerspectiveIds = this.getPerspectiveIds(this.navItem, true);
            if (visiblePerspectiveIds.isEmpty() || visiblePerspectiveIds.contains(navCtx.getResourceId())) {
                this.perspectiveId = navCtx.getResourceId();
            } else if (!visiblePerspectiveIds.isEmpty()) {
                this.perspectiveId = visiblePerspectiveIds.iterator().next();
                navCtx.setResourceId(this.perspectiveId);
                this.navItem.setContext(navCtx.toString());
            }
            Set<String> hiddenPerspectiveIds = this.getPerspectiveIds(this.navItem, false);
            boolean isRuntimePerspective = this.perspectivePluginManager.isRuntimePerspective(this.perspectiveId);
            String selectedNavGroupId = navCtx.getNavGroupId();
            this.targetPerspectiveEditor.clear();
            this.targetPerspectiveEditor.setPerspectiveId(this.perspectiveId);
            this.targetPerspectiveEditor.setNavGroupId(selectedNavGroupId);
            this.targetPerspectiveEditor.setPerspectiveIdsExcluded(hiddenPerspectiveIds);
            this.targetPerspectiveEditor.show();
            this.itemType = isRuntimePerspective ? ItemType.RUNTIME_PERSPECTIVE : ItemType.PERSPECTIVE;
            this.view.setItemType(this.itemType);
            this.view.setContextWidget(this.targetPerspectiveEditor);
        }
        this.view.setItemEditable(this.editEnabled);
        this.view.setItemDeletable(this.deleteEnabled);
        this.addCommands();
    }

    public void clear() {
        this.navItem = null;
        this.perspectiveId = null;
        this.view.clearChildren();
        this.view.clearCommands();
    }

    public boolean areChildrenAllowed() {
        return this.areChildrenAllowed(0, this);
    }

    public boolean areSubgroupsAllowed() {
        return this.areSubgroupsAllowed(0, this);
    }

    private boolean areChildrenAllowed(int levels, NavItemEditor editor) {
        int itemMaxLevels;
        if (editor == null) {
            return this.settings == null || this.settings.getMaxLevels() < 0 || levels < this.settings.getMaxLevels();
        }
        int n = itemMaxLevels = this.settings != null ? this.settings.getMaxLevels(editor.getNavItem().getId()) : -1;
        return itemMaxLevels != -1 ? levels < itemMaxLevels : this.areChildrenAllowed(levels + 1, editor.getParentEditor());
    }

    private boolean areSubgroupsAllowed(int levels, NavItemEditor editor) {
        int itemMaxLevels;
        if (editor == null) {
            return this.settings == null || this.settings.getMaxLevels() < 0 || levels < this.settings.getMaxLevels() - 1;
        }
        int n = itemMaxLevels = this.settings != null ? this.settings.getMaxLevels(editor.getNavItem().getId()) - 1 : -1;
        return itemMaxLevels > -1 ? levels < itemMaxLevels : this.areSubgroupsAllowed(levels + 1, editor.getParentEditor());
    }

    public NavItemEditor createChildEditor(NavItem navItem) {
        Class<? extends NavItemEditor> childEditorClass = this.getChildEditorClass();
        NavItemEditor navItemEditor = (NavItemEditor)this.beanManager.lookupBean(childEditorClass, new Annotation[0]).newInstance();
        navItemEditor.setParentEditor(this);
        navItemEditor.setSettings(this.settings);
        navItemEditor.setOnUpdateCommand(() -> this.onUpdateChild(navItem, navItemEditor));
        navItemEditor.setOnCancelCommand(() -> this.onCancelChild(navItem, navItemEditor));
        navItemEditor.setOnDeleteCommand(() -> this.onDeleteChild(navItemEditor));
        navItemEditor.setOnMoveFirstCommand(() -> this.onMoveFirstChild(navItemEditor));
        navItemEditor.setOnMoveLastCommand(() -> this.onMoveLastChild(navItemEditor));
        navItemEditor.setOnMoveUpCommand(() -> this.onMoveUpChild(navItemEditor));
        navItemEditor.setOnMoveDownCommand(() -> this.onMoveDownChild(navItemEditor));
        return navItemEditor;
    }

    public Set<String> getPerspectiveIds(NavItem navItem, boolean visible) {
        boolean onlyRuntime = this.settings == null || this.settings.onlyRuntimePerspectives(navItem);
        Set<String> runtimeIds = this.getRuntimePerspectiveIds();
        Set<String> hardCodedIds = this.getHardCodedPerspectiveIds();
        Set excludedIds = this.perspectiveTreeProvider.getPerspectiveIdsExcluded();
        if (visible) {
            if (!onlyRuntime) {
                runtimeIds.addAll(hardCodedIds);
            }
            return runtimeIds.stream().filter(id -> !excludedIds.contains(id)).collect(Collectors.toSet());
        }
        if (onlyRuntime) {
            hardCodedIds.addAll(excludedIds);
            return hardCodedIds;
        }
        return excludedIds;
    }

    private Set<String> getRuntimePerspectiveIds() {
        HashSet<String> result = new HashSet<String>();
        this.perspectivePluginManager.getPerspectivePlugins((ParameterizedCommand<Collection<Plugin>>)((ParameterizedCommand)plugins -> plugins.forEach(p -> {
            String perspectiveId = p.getName();
            result.add(perspectiveId);
        })));
        return result;
    }

    private Set<String> getHardCodedPerspectiveIds() {
        HashSet<String> result = new HashSet<String>();
        Collection beanDefs = this.beanManager.lookupBeans(AbstractWorkbenchPerspectiveActivity.class);
        beanDefs.forEach(beanDef -> {
            AbstractWorkbenchPerspectiveActivity bean = (AbstractWorkbenchPerspectiveActivity)beanDef.getInstance();
            String perspectiveId = bean.getIdentifier();
            result.add(perspectiveId);
            this.beanManager.destroyBean((Object)bean);
        });
        return result;
    }

    private void addCommands() {
        boolean dividerRequired = false;
        if (this.creationEnabled) {
            boolean newPerspectiveEnabled;
            boolean newDividerEnabled;
            boolean newGroupEnabled = this.isNewGroupEnabled();
            if (newGroupEnabled) {
                this.addCommand(this.view.i18nNewItem(this.getGroupLiteral()), this::newGroup);
                dividerRequired = true;
            }
            if (newDividerEnabled = this.isNewDividerEnabled()) {
                this.addCommand(this.view.i18nNewItem(this.getDividerLiteral()), this::newDivider);
                dividerRequired = true;
            }
            if (newPerspectiveEnabled = this.isNewPerspectiveEnabled()) {
                this.addCommand(this.view.i18nNewItem(this.getPerspectiveLiteral()), this::newPerspective);
                dividerRequired = true;
            }
        }
        if (this.moveUpEnabled || this.moveDownEnabled) {
            if (dividerRequired) {
                this.view.addCommandDivider();
            }
            dividerRequired = true;
            if (this.moveUpEnabled) {
                this.addCommand(this.view.i18nMoveFirst(), this::moveFirstCommand);
                this.addCommand(this.view.i18nMoveUp(), this::moveUpCommand);
            }
            if (this.moveDownEnabled) {
                this.addCommand(this.view.i18nMoveDown(), this::moveDownCommand);
                this.addCommand(this.view.i18nMoveLast(), this::moveLastCommand);
            }
        }
        if (this.isGotoPerspectiveEnabled()) {
            if (dividerRequired) {
                this.view.addCommandDivider();
            }
            dividerRequired = true;
            this.addCommand(this.view.i18nGotoItem(this.getPerspectiveLiteral()), this::gotoPerspectiveCommand);
        }
    }

    private void addCommand(String name, Command action) {
        this.view.addCommand(name, action);
        this.view.setCommandsEnabled(true);
    }

    private void refreshCommands() {
        this.view.clearCommands();
        this.addCommands();
    }

    public NavItemEditor newGroup() {
        NavGroup navGroup = (NavGroup)this.navItem;
        String id = "group_" + this.view.generateId();
        String name = i18n.newItemName(this.getGroupLiteral());
        NavGroup newItem = NavFactory.get().createNavGroup();
        newItem.setParent(navGroup);
        newItem.setId(id);
        newItem.setName(name);
        newItem.setModifiable(true);
        NavItemEditor childEditor = this.registerChild((NavItem)newItem);
        childEditor.startEdition();
        this.expand();
        return childEditor;
    }

    public NavItemEditor newPerspective() {
        NavGroup navGroup = (NavGroup)this.navItem;
        String id = "perspective_" + this.view.generateId();
        String name = i18n.newItemName(this.getPerspectiveLiteral());
        NavItem newItem = NavFactory.get().createNavItem();
        newItem.setParent(navGroup);
        newItem.setId(id);
        newItem.setName(name);
        newItem.setModifiable(true);
        Set<String> visiblePerspectiveIds = this.getPerspectiveIds((NavItem)navGroup, true);
        if (!visiblePerspectiveIds.isEmpty()) {
            String firstPerspective = visiblePerspectiveIds.iterator().next();
            newItem.setContext(NavWorkbenchCtx.perspective((String)firstPerspective).toString());
        }
        NavItemEditor childEditor = this.registerChild(newItem);
        childEditor.startEdition();
        this.expand();
        return childEditor;
    }

    public NavItemEditor newDivider() {
        NavGroup navGroup = (NavGroup)this.navItem;
        String id = "divider_" + this.view.generateId();
        NavDivider newItem = NavFactory.get().createDivider();
        newItem.setId(id);
        newItem.setParent(navGroup);
        newItem.setModifiable(true);
        NavItemEditor childEditor = this.registerChild((NavItem)newItem);
        this.onUpdateChild((NavItem)newItem, childEditor);
        this.expand();
        return childEditor;
    }

    void gotoPerspectiveCommand() {
        if (this.perspectiveId != null) {
            this.placeManager.goTo(this.perspectiveId);
        }
    }

    void deleteItemCommand() {
        if (this.deleteEnabled && this.onDeleteCommand != null) {
            this.onDeleteCommand.execute();
        }
    }

    void moveUpCommand() {
        if (this.onMoveUpCommand != null) {
            this.onMoveUpCommand.execute();
        }
    }

    void moveDownCommand() {
        if (this.onMoveDownCommand != null) {
            this.onMoveDownCommand.execute();
        }
    }

    void moveFirstCommand() {
        if (this.onMoveFirstCommand != null) {
            this.onMoveFirstCommand.execute();
        }
    }

    void moveLastCommand() {
        if (this.onMoveLastCommand != null) {
            this.onMoveLastCommand.execute();
        }
    }

    void onItemUpdated() {
        this.navItemBackup = this.navItem.cloneItem();
        if (this.onUpdateCommand != null) {
            this.onUpdateCommand.execute();
        }
    }

    void onEditCancelled() {
        if (this.onCancelCommand != null) {
            this.onCancelCommand.execute();
        }
    }

    void onMoveUpChild(NavItemEditor navItemEditor) {
        int idx;
        if (this.childEditorList.size() > 1 && (idx = this.childEditorList.indexOf(navItemEditor)) > 0 && idx < this.childEditorList.size()) {
            this.childEditorList.remove(idx);
            this.childEditorList.add(idx - 1, navItemEditor);
            this.refreshChildren();
            NavGroup navGroup = (NavGroup)this.navItem;
            navGroup.getChildren().remove(idx);
            navGroup.getChildren().add(idx - 1, navItemEditor.getNavItem());
            this.onItemUpdated();
        }
    }

    void onMoveDownChild(NavItemEditor navItemEditor) {
        int idx;
        if (this.childEditorList.size() > 1 && (idx = this.childEditorList.indexOf(navItemEditor)) > -1 && idx < this.childEditorList.size() - 1) {
            this.childEditorList.remove(idx);
            this.childEditorList.add(idx + 1, navItemEditor);
            this.refreshChildren();
            NavGroup navGroup = (NavGroup)this.navItem;
            navGroup.getChildren().remove(idx);
            navGroup.getChildren().add(idx + 1, navItemEditor.getNavItem());
            this.onItemUpdated();
        }
    }

    void onMoveFirstChild(NavItemEditor navItemEditor) {
        int idx;
        if (this.childEditorList.size() > 1 && (idx = this.childEditorList.indexOf(navItemEditor)) > 0 && idx < this.childEditorList.size()) {
            this.childEditorList.remove(idx);
            this.childEditorList.add(0, navItemEditor);
            this.refreshChildren();
            NavGroup navGroup = (NavGroup)this.navItem;
            navGroup.getChildren().remove(idx);
            navGroup.getChildren().add(0, navItemEditor.getNavItem());
            this.onItemUpdated();
        }
    }

    void onMoveLastChild(NavItemEditor navItemEditor) {
        int idx;
        if (this.childEditorList.size() > 1 && (idx = this.childEditorList.indexOf(navItemEditor)) > -1 && idx < this.childEditorList.size() - 1) {
            this.childEditorList.remove(idx);
            this.childEditorList.add(navItemEditor);
            this.refreshChildren();
            NavGroup navGroup = (NavGroup)this.navItem;
            navGroup.getChildren().remove(idx);
            navGroup.getChildren().add(navItemEditor.getNavItem());
            this.onItemUpdated();
        }
    }

    void onUpdateChild(NavItem oldItem, NavItemEditor childEditor) {
        NavItem newItem = childEditor.getNavItem();
        NavGroup navGroup = (NavGroup)this.navItem;
        int idx = navGroup.getChildren().indexOf(oldItem);
        if (idx != -1) {
            navGroup.getChildren().remove(idx);
            navGroup.getChildren().add(idx, newItem);
            this.onItemUpdated();
        } else {
            navGroup.getChildren().add(newItem);
            this.onItemUpdated();
        }
    }

    void onCancelChild(NavItem oldItem, NavItemEditor childEditor) {
        NavGroup navGroup = (NavGroup)this.navItem;
        int idx = navGroup.getChildren().indexOf(oldItem);
        if (idx == -1) {
            this.childEditorList.remove(childEditor);
            this.refreshChildren();
        }
    }

    void onDeleteChild(NavItemEditor navItemEditor) {
        NavGroup navGroup = (NavGroup)this.navItem;
        navGroup.getChildren().remove(navItemEditor.getNavItem());
        this.childEditorList.remove(navItemEditor);
        this.refreshChildren();
        this.onItemUpdated();
    }

    private void registerChildren(NavGroup navGroup) {
        ArrayList<NavItemEditor> oldChildEditorList = new ArrayList<NavItemEditor>(this.childEditorList);
        this.childEditorList.clear();
        List childList = navGroup.getChildren();
        for (int i = 0; i < childList.size(); ++i) {
            NavItem childItem = (NavItem)childList.get(i);
            if (childItem instanceof NavGroup && !this.areSubgroupsAllowed()) continue;
            Optional<NavItemEditor> result = oldChildEditorList.stream().filter(editor -> editor.getNavItem().equals(childItem)).findFirst();
            NavItemEditor childEditor = result.isPresent() ? result.get() : this.createChildEditor(childItem);
            oldChildEditorList.remove(childEditor);
            childEditor.edit(childItem);
            this.childEditorList.add(childEditor);
        }
        oldChildEditorList.forEach(arg_0 -> ((SyncBeanManager)this.beanManager).destroyBean(arg_0));
        oldChildEditorList.clear();
        this.refreshChildren();
    }

    private NavItemEditor registerChild(NavItem item) {
        NavItemEditor childEditor = this.createChildEditor(item);
        childEditor.edit(item);
        this.childEditorList.add(childEditor);
        this.refreshChildren();
        return childEditor;
    }

    private void refreshChildren() {
        this.view.clearChildren();
        this.view.setExpandEnabled(this.canBeExpanded());
        if (this.childEditorList.isEmpty()) {
            this.expanded = false;
            this.view.setExpanded(false);
        }
        for (int i = 0; i < this.childEditorList.size(); ++i) {
            NavItemEditor childEditor = this.childEditorList.get(i);
            childEditor.setMoveUpEnabled(i > 0);
            childEditor.setMoveDownEnabled(i < this.childEditorList.size() - 1);
            childEditor.refreshCommands();
            this.view.addChild(childEditor);
        }
    }

    void onChangesOk() {
        boolean error = false;
        String name = this.view.getItemName();
        if (name != null && !name.trim().isEmpty()) {
            if (!name.equals(this.navItem.getName())) {
                this.navItem.setName(name);
                this.view.setItemName(name);
                String newPerspectiveI18n = this.getNewPerspectiveI18n();
                this.itemNameFromPerspective = newPerspectiveI18n.equals(name);
            }
        } else {
            error = true;
            this.view.setItemNameError(error);
        }
        if (!error && ItemType.PERSPECTIVE.equals((Object)this.itemType) || ItemType.RUNTIME_PERSPECTIVE.equals((Object)this.itemType)) {
            boolean isRuntimePerspective;
            NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)this.navItem);
            String oldPerspectiveId = navCtx.getResourceId();
            String newPerspectiveId = this.targetPerspectiveEditor.getPerspectiveId();
            if (newPerspectiveId != null && !newPerspectiveId.trim().isEmpty()) {
                if (oldPerspectiveId != null && !oldPerspectiveId.equals(newPerspectiveId)) {
                    this.perspectiveId = newPerspectiveId;
                    navCtx.setResourceId(this.perspectiveId);
                    this.navItem.setContext(navCtx.toString());
                }
            } else {
                error = true;
            }
            String newGroupId = (isRuntimePerspective = this.perspectivePluginManager.isRuntimePerspective(newPerspectiveId)) ? this.targetPerspectiveEditor.getNavGroupId() : null;
            String oldGroupId = navCtx.getNavGroupId();
            if (oldGroupId == null && newGroupId != null || oldGroupId != null && !oldGroupId.equals(newGroupId)) {
                navCtx.setNavGroupId(newGroupId);
                this.navItem.setContext(navCtx.toString());
            }
        }
        if (!error) {
            this.finishEdition();
            this.onItemUpdated();
        }
    }

    void onItemNameChanged() {
        this.itemNameFromPerspective = false;
    }

    void onTargetPerspectiveUpdated() {
        String perspectiveId = this.targetPerspectiveEditor.getPerspectiveId();
        if (this.itemNameFromPerspective) {
            String perspectiveName = this.targetPerspectiveEditor.getPerspectiveName(perspectiveId);
            this.view.setItemName(perspectiveName);
        }
        if (this.settings == null || this.settings.isPerspectiveContextEnabled(this.navItem)) {
            this.perspectivePluginManager.getLayoutTemplateInfo(perspectiveId, (ParameterizedCommand<LayoutTemplateInfo>)((ParameterizedCommand)info -> this.targetPerspectiveEditor.setNavGroupEnabled(info != null && info.hasNavigationComponents())));
        }
    }

    public static interface View<P extends NavItemEditor>
    extends UberElement<P> {
        public void clearChildren();

        public void addChild(IsElement var1);

        public void setExpandEnabled(boolean var1);

        public void setExpanded(boolean var1);

        public void setItemName(String var1);

        public String getItemName();

        public void setItemNameError(boolean var1);

        public void setItemDescription(String var1);

        public void setItemType(ItemType var1);

        public void addCommand(String var1, Command var2);

        public void addCommandDivider();

        public void setCommandsEnabled(boolean var1);

        public void clearCommands();

        public void setItemEditable(boolean var1);

        public void setItemDeletable(boolean var1);

        public void startItemEdition();

        public void finishItemEdition();

        public void setContextWidget(IsElement var1);

        public String i18nNewItem(String var1);

        public String i18nNewItemName(String var1);

        public String i18nGotoItem(String var1);

        public String i18nDeleteItem();

        public String i18nMoveUp();

        public String i18nMoveDown();

        public String i18nMoveFirst();

        public String i18nMoveLast();

        public String generateId();
    }

    public static enum ItemType {
        DIVIDER,
        GROUP,
        PERSPECTIVE,
        RUNTIME_PERSPECTIVE;

    }
}

