/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.NavTabListWidget;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class NavTabListWidgetTest {
    @Mock
    NavTabListWidget.View view;
    @Mock
    NavTabListWidget.View viewAdmin;
    @Mock
    NavTabListWidget.View viewDashboards;
    @Mock
    SyncBeanDef<NavTabListWidget> tablistBean;
    @Mock
    PerspectivePluginManager pluginManager;
    @Mock
    NavigationManager navigationManager;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    PlaceManager placeManager;
    NavTabListWidget tabsAdmin;
    NavTabListWidget tabsDashboards;
    NavTabListWidget presenter;
    NavTree tree;
    public static final String ITEM_ID_HOME = "home";
    public static final String ITEM_ID_GALLERY = "gallery";
    public static final String ITEM_ID_ADMIN = "admin";
    public static final String ITEM_ID_DATASETS = "datasets";
    public static final String ITEM_ID_CONTENTMGMT = "contentmgmt";
    public static final String ITEM_ID_DASHBOARDS = "dashboards";
    public static final String ITEM_ID_DASHBOARD1 = "dashboard1";
    public static final String ITEM_ID_DASHBOARD2 = "dashboard2";

    @Before
    public void setUp() throws Exception {
        this.tabsAdmin = new NavTabListWidget(this.viewAdmin, this.beanManager, this.pluginManager, this.placeManager, this.navigationManager);
        this.tabsDashboards = new NavTabListWidget(this.viewDashboards, this.beanManager, this.pluginManager, this.placeManager, this.navigationManager);
        this.presenter = new NavTabListWidget(this.view, this.beanManager, this.pluginManager, this.placeManager, this.navigationManager);
        this.presenter.setGotoItemEnabled(true);
        this.tree = new NavTreeBuilder().item(ITEM_ID_HOME, "Home", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_HOME)).item(ITEM_ID_GALLERY, "Gallery", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_GALLERY)).group(ITEM_ID_ADMIN, "Administration", null, false).item(ITEM_ID_DATASETS, "Datasets", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_DATASETS)).item(ITEM_ID_CONTENTMGMT, "Content Manager", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_CONTENTMGMT)).endGroup().group(ITEM_ID_DASHBOARDS, "Dashboards", null, false).item(ITEM_ID_DASHBOARD1, "Dashboard 1", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_DASHBOARD1)).item(ITEM_ID_DASHBOARD2, "Dashboard 2", null, false, (NavItemContext)NavWorkbenchCtx.perspective((String)ITEM_ID_DASHBOARD2)).endGroup().build();
        Mockito.when((Object)this.beanManager.lookupBean(NavTabListWidget.class, new Annotation[0])).thenReturn(this.tablistBean);
        Mockito.when((Object)this.tablistBean.newInstance()).thenReturn((Object)this.tabsAdmin, (Object[])new NavTabListWidget[]{this.tabsDashboards});
        Mockito.when((Object)this.pluginManager.isRuntimePerspective((NavItem)Mockito.any(NavItem.class))).thenReturn((Object)true);
    }

    @Test
    public void testShow() {
        this.presenter.show(this.tree);
        Assert.assertEquals((Object)this.presenter.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_HOME));
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)ITEM_ID_HOME), Mockito.anyString(), (String)Mockito.any(), (Command)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).addItem((String)Mockito.eq((Object)ITEM_ID_GALLERY), Mockito.anyString(), (String)Mockito.any(), (Command)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).addGroupItem((String)Mockito.eq((Object)ITEM_ID_ADMIN), Mockito.anyString(), (String)Mockito.any(), (IsWidget)Mockito.eq((Object)this.tabsAdmin));
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).addGroupItem((String)Mockito.eq((Object)ITEM_ID_DASHBOARDS), Mockito.anyString(), (String)Mockito.any(), (IsWidget)Mockito.eq((Object)this.tabsDashboards));
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).setSelectedItem(ITEM_ID_HOME);
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewAdmin)).showAsSubmenu(true);
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewAdmin, (VerificationMode)Mockito.never())).showChildrenTabs((IsWidget)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewAdmin)).addItem((String)Mockito.eq((Object)ITEM_ID_DATASETS), Mockito.anyString(), (String)Mockito.any(), (Command)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewAdmin)).addItem((String)Mockito.eq((Object)ITEM_ID_CONTENTMGMT), Mockito.anyString(), (String)Mockito.any(), (Command)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewDashboards)).showAsSubmenu(true);
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewDashboards, (VerificationMode)Mockito.never())).showChildrenTabs((IsWidget)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewDashboards)).addItem((String)Mockito.eq((Object)ITEM_ID_DASHBOARD1), Mockito.anyString(), (String)Mockito.any(), (Command)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewDashboards)).addItem((String)Mockito.eq((Object)ITEM_ID_DASHBOARD2), Mockito.anyString(), (String)Mockito.any(), (Command)Mockito.any());
    }

    @Test
    public void testDefaultNestedItem() {
        this.presenter.setDefaultNavItemId(ITEM_ID_DASHBOARD2);
        this.presenter.show(this.tree);
        Assert.assertEquals((Object)this.presenter.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_DASHBOARD2));
        Assert.assertEquals((Object)this.tabsDashboards.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_DASHBOARD2));
        Assert.assertNull((Object)this.tabsAdmin.getItemSelected());
        ((NavTabListWidget.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).clearSelectedItem();
        ((NavTabListWidget.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setSelectedItem(ITEM_ID_DASHBOARDS);
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).showChildrenTabs((IsWidget)this.tabsDashboards);
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewDashboards)).setSelectedItem(ITEM_ID_DASHBOARD2);
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewAdmin, (VerificationMode)Mockito.never())).showChildrenTabs((IsWidget)Mockito.any());
    }

    @Test
    public void testSelectNestedItem() {
        this.presenter.show(this.tree);
        Mockito.reset((Object[])new NavTabListWidget.View[]{this.view, this.viewAdmin, this.viewDashboards});
        this.presenter.setSelectedItem(ITEM_ID_CONTENTMGMT);
        Assert.assertEquals((Object)this.presenter.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_CONTENTMGMT));
        Assert.assertEquals((Object)this.tabsAdmin.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_CONTENTMGMT));
        Assert.assertNull((Object)this.tabsDashboards.getItemSelected());
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).clearSelectedItem();
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).showChildrenTabs((IsWidget)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewAdmin)).setSelectedItem(ITEM_ID_CONTENTMGMT);
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewDashboards, (VerificationMode)Mockito.never())).showChildrenTabs((IsWidget)Mockito.any());
    }

    @Test
    public void testSwitchFromNestedToRoot() {
        this.presenter.show(this.tree);
        this.presenter.setSelectedItem(ITEM_ID_CONTENTMGMT);
        Mockito.reset((Object[])new NavTabListWidget.View[]{this.view, this.viewAdmin, this.viewDashboards});
        this.presenter.onItemClicked(this.tree.getItemById(ITEM_ID_HOME));
        Assert.assertEquals((Object)this.presenter.getItemSelected(), (Object)this.tree.getItemById(ITEM_ID_HOME));
        Assert.assertNull((Object)this.tabsAdmin.getItemSelected());
        Assert.assertNull((Object)this.tabsDashboards.getItemSelected());
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).clearSelectedItem();
        ((NavTabListWidget.View)Mockito.verify((Object)this.view)).setSelectedItem(ITEM_ID_HOME);
        ((NavTabListWidget.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showChildrenTabs((IsWidget)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewAdmin, (VerificationMode)Mockito.never())).showChildrenTabs((IsWidget)Mockito.any());
        ((NavTabListWidget.View)Mockito.verify((Object)this.viewDashboards, (VerificationMode)Mockito.never())).showChildrenTabs((IsWidget)Mockito.any());
    }
}

