/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavItemEditCancelledEvent;
import org.dashbuilder.client.navigation.event.NavItemEditStartedEvent;
import org.dashbuilder.client.navigation.event.NavItemGotoEvent;
import org.dashbuilder.client.navigation.event.NavTreeLoadedEvent;
import org.dashbuilder.client.navigation.impl.NavigationManagerImpl;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.editor.NavItemDefaultEditor;
import org.dashbuilder.client.navigation.widget.editor.NavItemDefaultEditorView;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditor;
import org.dashbuilder.client.navigation.widget.editor.NavRootNodeEditor;
import org.dashbuilder.client.navigation.widget.editor.NavRootNodeEditorView;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditor;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditorView;
import org.dashbuilder.client.navigation.widget.editor.TargetPerspectiveEditor;
import org.dashbuilder.client.widgets.common.LoadingBox;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.event.NavTreeChangedEvent;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.dashbuilder.navigation.service.NavigationServices;
import org.dashbuilder.navigation.workbench.NavSecurityController;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class NavTreeEditorTest {
    @Mock
    NavTreeEditorView view;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    PerspectiveTreeProvider perspectiveTreeProvider;
    @Mock
    EventSourceMock<NavItemEditStartedEvent> navItemEditStartedEvent;
    @Mock
    EventSourceMock<NavItemEditCancelledEvent> navItemEditCancelledEvent;
    @Mock
    LoadingBox loadingBox;
    @Mock
    EventSourceMock<NavItemGotoEvent> navItemGotoEvent;
    @Mock
    EventSourceMock<NavTreeLoadedEvent> navTreeLoadedEvent;
    @Mock
    EventSourceMock<NavTreeChangedEvent> navTreeChangedEvent;
    @Mock
    NavigationServices navServices;
    @Mock
    NavSecurityController navController;
    @Mock
    PlaceManager placeManager;
    @Mock
    TargetPerspectiveEditor targetPerspectiveEditor;
    @Mock
    PerspectivePluginManager perspectivePluginManager;
    @Mock
    NavItemDefaultEditorView navItemEditorView;
    @Mock
    NavRootNodeEditorView navRootNodeEditorView;
    @Mock
    SyncBeanDef<NavItemDefaultEditor> navItemEditorBeanDef;
    @Mock
    SyncBeanDef<NavRootNodeEditor> navRootNodeEditorBeanDef;
    @Mock
    Command updateCommand;
    @Mock
    Plugin perspectivePlugin;
    Collection<Plugin> perspectivePlugins = new HashSet<Plugin>();
    NavigationManager navigationManager;
    NavTreeEditor navTreeEditor;
    NavItemDefaultEditor navItemEditor;
    NavRootNodeEditor navRootNodeEditor;
    NavTree NAV_TREE = new NavTreeBuilder().group("level1a", "level1a", "level1a", true).group("level2a", "level2a", "level2a", true).endGroup().endGroup().group("level1b", "level1b", "level1b", true).group("level2b", "level2b", "level2b", true).endGroup().endGroup().build();

    @Before
    public void setUp() {
        this.navigationManager = (NavigationManager)Mockito.spy((Object)new NavigationManagerImpl((Caller)new CallerMock((Object)this.navServices), this.navController, this.navTreeLoadedEvent, this.navTreeChangedEvent, this.navItemGotoEvent));
        this.navTreeEditor = (NavTreeEditor)Mockito.spy((Object)new NavTreeEditor(this.view, this.navigationManager, this.beanManager, this.placeManager, this.perspectiveTreeProvider, this.targetPerspectiveEditor, this.perspectivePluginManager, this.navItemEditStartedEvent, this.navItemEditCancelledEvent, this.loadingBox));
        this.navTreeEditor.setChildEditorClass(NavRootNodeEditor.class);
        this.navItemEditor = (NavItemDefaultEditor)Mockito.spy((Object)new NavItemDefaultEditor(this.navItemEditorView, this.beanManager, this.placeManager, this.perspectiveTreeProvider, this.targetPerspectiveEditor, this.perspectivePluginManager, this.navItemEditStartedEvent, this.navItemEditCancelledEvent));
        this.navRootNodeEditor = (NavRootNodeEditor)Mockito.spy((Object)new NavRootNodeEditor(this.navRootNodeEditorView, this.beanManager, this.placeManager, this.perspectiveTreeProvider, this.targetPerspectiveEditor, this.perspectivePluginManager, this.navItemEditStartedEvent, this.navItemEditCancelledEvent));
        Mockito.when((Object)this.beanManager.lookupBean(NavItemDefaultEditor.class, new Annotation[0])).thenReturn(this.navItemEditorBeanDef);
        Mockito.when((Object)this.beanManager.lookupBean(NavRootNodeEditor.class, new Annotation[0])).thenReturn(this.navRootNodeEditorBeanDef);
        Mockito.when((Object)this.navItemEditorBeanDef.newInstance()).thenReturn((Object)this.navItemEditor);
        Mockito.when((Object)this.navRootNodeEditorBeanDef.newInstance()).thenReturn((Object)this.navRootNodeEditor);
        Mockito.when((Object)this.navItemEditorView.getItemName()).thenReturn((Object)"editor1");
        Mockito.when((Object)this.navRootNodeEditorView.getItemName()).thenReturn((Object)"editor2");
        this.perspectivePlugins.add(this.perspectivePlugin);
        ((PerspectivePluginManager)Mockito.doAnswer(invocationOnMock -> {
            ParameterizedCommand callback = (ParameterizedCommand)invocationOnMock.getArguments()[0];
            callback.execute(this.perspectivePlugins);
            return null;
        }).when((Object)this.perspectivePluginManager)).getPerspectivePlugins((ParameterizedCommand)Mockito.any());
    }

    @Test
    public void testNewPerspectiveEnabled() {
        this.navTreeEditor.getSettings().setNewPerspectiveEnabled(true);
        Assert.assertTrue((boolean)this.navTreeEditor.getSettings().isNewPerspectiveEnabled(this.NAV_TREE.getItemById("level1b")));
        this.navTreeEditor.setNewPerspectiveEnabled("level1b", false);
        Assert.assertFalse((boolean)this.navTreeEditor.getSettings().isNewPerspectiveEnabled(this.NAV_TREE.getItemById("level1b")));
        Assert.assertTrue((boolean)this.navTreeEditor.getSettings().isNewPerspectiveEnabled(this.NAV_TREE.getItemById("level2b")));
        this.navTreeEditor.setNewPerspectiveEnabled("level1b", false).applyToAllChildren();
        Assert.assertFalse((boolean)this.navTreeEditor.getSettings().isNewPerspectiveEnabled(this.NAV_TREE.getItemById("level1b")));
        Assert.assertFalse((boolean)this.navTreeEditor.getSettings().isNewPerspectiveEnabled(this.NAV_TREE.getItemById("level2b")));
    }

    @Test
    public void testNewDividerEnabled() {
        this.navTreeEditor.getSettings().setNewDividerEnabled(true);
        Assert.assertTrue((boolean)this.navTreeEditor.getSettings().isNewDividerEnabled(this.NAV_TREE.getItemById("level1b")));
        this.navTreeEditor.setNewDividerEnabled("level1b", false);
        Assert.assertFalse((boolean)this.navTreeEditor.getSettings().isNewDividerEnabled(this.NAV_TREE.getItemById("level1b")));
        Assert.assertTrue((boolean)this.navTreeEditor.getSettings().isNewDividerEnabled(this.NAV_TREE.getItemById("level2b")));
        this.navTreeEditor.setNewDividerEnabled("level1b", false).applyToAllChildren();
        Assert.assertFalse((boolean)this.navTreeEditor.getSettings().isNewDividerEnabled(this.NAV_TREE.getItemById("level1b")));
        Assert.assertFalse((boolean)this.navTreeEditor.getSettings().isNewDividerEnabled(this.NAV_TREE.getItemById("level2b")));
    }

    @Test
    public void testAllSubgroupsAllowed() {
        this.navTreeEditor.getSettings().setMaxLevels(-1);
        this.navTreeEditor.edit(this.NAV_TREE);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.times((int)2))).createChildEditor((NavItem)Mockito.any());
        ((NavRootNodeEditor)Mockito.verify((Object)this.navRootNodeEditor, (VerificationMode)Mockito.times((int)2))).createChildEditor((NavItem)Mockito.any());
        ((NavItemDefaultEditor)Mockito.verify((Object)this.navItemEditor, (VerificationMode)Mockito.never())).createChildEditor((NavItem)Mockito.any());
    }

    @Test
    public void testNoSubgroupsAllowed() {
        this.navTreeEditor.getSettings().setMaxLevels(1);
        this.navTreeEditor.edit(this.NAV_TREE);
        NavItem level1a = this.NAV_TREE.getItemById("level1a");
        NavItem level2a = this.NAV_TREE.getItemById("level2a");
        NavItem level1b = this.NAV_TREE.getItemById("level1b");
        NavItem level2b = this.NAV_TREE.getItemById("level2b");
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.never())).createChildEditor((NavItem)Mockito.eq((Object)level1a));
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.never())).createChildEditor((NavItem)Mockito.eq((Object)level1b));
        ((NavRootNodeEditor)Mockito.verify((Object)this.navRootNodeEditor, (VerificationMode)Mockito.never())).createChildEditor((NavItem)Mockito.eq((Object)level2b));
        ((NavRootNodeEditor)Mockito.verify((Object)this.navRootNodeEditor, (VerificationMode)Mockito.never())).createChildEditor((NavItem)Mockito.eq((Object)level2a));
    }

    @Test
    public void testSubgroupNotAllowed() {
        NavItem level1a = this.NAV_TREE.getItemById("level1a");
        NavItem level2a = this.NAV_TREE.getItemById("level2a");
        NavItem level1b = this.NAV_TREE.getItemById("level1b");
        NavItem level2b = this.NAV_TREE.getItemById("level2b");
        this.navTreeEditor.getSettings().setMaxLevels("level1a", 1);
        this.navTreeEditor.edit(this.NAV_TREE);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).createChildEditor((NavItem)Mockito.eq((Object)level1a));
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).createChildEditor((NavItem)Mockito.eq((Object)level1b));
        ((NavRootNodeEditor)Mockito.verify((Object)this.navRootNodeEditor)).createChildEditor((NavItem)Mockito.eq((Object)level2b));
        ((NavRootNodeEditor)Mockito.verify((Object)this.navRootNodeEditor, (VerificationMode)Mockito.never())).createChildEditor((NavItem)Mockito.eq((Object)level2a));
    }

    @Test
    public void testOnlyThreeLevelsAllowed() {
        NavItem level1a = this.NAV_TREE.getItemById("level1a");
        NavItem level2a = this.NAV_TREE.getItemById("level2a");
        NavItem level1b = this.NAV_TREE.getItemById("level1b");
        NavItem level2b = this.NAV_TREE.getItemById("level2b");
        this.navTreeEditor.getSettings().setMaxLevels("root", 3);
        this.navTreeEditor.edit(this.NAV_TREE);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).createChildEditor((NavItem)Mockito.eq((Object)level1a));
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).createChildEditor((NavItem)Mockito.eq((Object)level1b));
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.never())).createChildEditor((NavItem)Mockito.eq((Object)level2a));
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.never())).createChildEditor((NavItem)Mockito.eq((Object)level2b));
    }

    @Test
    public void testFinishEdition() {
        this.navTreeEditor.edit(this.NAV_TREE);
        this.navRootNodeEditor.newGroup();
        this.navRootNodeEditor.finishEdition();
        Assert.assertNull((Object)this.navTreeEditor.getCurrentlyEditedItem());
    }

    @Test
    public void itShouldBeImpossibleToOpenMultipleNavItemEditorInputs() {
        NavTree tree = NavFactory.get().createNavTree();
        this.navTreeEditor.edit(tree);
        NavItemEditor first = (NavItemEditor)Mockito.mock(NavItemEditor.class);
        NavItemEditor second = (NavItemEditor)Mockito.mock(NavItemEditor.class);
        NavItem firstItem = (NavItem)Mockito.mock(NavItem.class);
        Mockito.when((Object)first.getNavItem()).thenReturn((Object)firstItem);
        this.navTreeEditor.onItemEditStarted(new NavItemEditStartedEvent(first));
        this.navTreeEditor.onItemEditStarted(new NavItemEditStartedEvent(second));
        ((NavItemEditor)Mockito.verify((Object)first)).cancelEdition();
    }

    @Test
    public void whenItemEditFinishedNavTreeEditorCleared() {
        this.navTreeEditor.edit(this.NAV_TREE);
        NavItemEditor navItemEditor = this.navTreeEditor.newGroup();
        this.navTreeEditor.onItemEditStarted(new NavItemEditStartedEvent(navItemEditor));
        Assert.assertEquals((Object)navItemEditor, this.navTreeEditor.currentlyEditedItem.get());
        navItemEditor.onItemUpdated();
        Assert.assertFalse((boolean)this.navTreeEditor.currentlyEditedItem.isPresent());
    }

    @Test
    public void testNewGroup() {
        this.navTreeEditor.setOnUpdateCommand(this.updateCommand);
        this.navTreeEditor.edit(this.NAV_TREE);
        this.navTreeEditor.collapse();
        Assert.assertFalse((boolean)this.navTreeEditor.isExpanded());
        Mockito.reset((Object[])new NavTreeEditorView[]{this.view});
        NavItemEditor navItemEditor = this.navTreeEditor.newGroup();
        Assert.assertEquals((long)((NavGroup)this.navTreeEditor.getNavItem()).getChildren().size(), (long)2L);
        Assert.assertTrue((boolean)this.navTreeEditor.isExpanded());
        ((NavItemEditor)Mockito.verify((Object)navItemEditor)).startEdition();
        ((NavTreeEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addChild((IsElement)Mockito.any());
        ((Command)Mockito.verify((Object)this.updateCommand, (VerificationMode)Mockito.never())).execute();
        Mockito.when((Object)this.navRootNodeEditorView.getItemName()).thenReturn((Object)"A");
        navItemEditor.onChangesOk();
        ((Command)Mockito.verify((Object)this.updateCommand)).execute();
    }

    @Test
    public void testNewPerspective() {
        this.navTreeEditor.setOnUpdateCommand(this.updateCommand);
        this.navTreeEditor.edit(this.NAV_TREE);
        this.navTreeEditor.collapse();
        Assert.assertFalse((boolean)this.navTreeEditor.isExpanded());
        Mockito.reset((Object[])new NavTreeEditorView[]{this.view});
        NavItemEditor navItemEditor = this.navTreeEditor.newPerspective();
        Assert.assertEquals((long)((NavGroup)this.navTreeEditor.getNavItem()).getChildren().size(), (long)2L);
        Assert.assertTrue((boolean)this.navTreeEditor.isExpanded());
        ((NavItemEditor)Mockito.verify((Object)navItemEditor)).startEdition();
        ((NavTreeEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addChild((IsElement)Mockito.any());
        ((Command)Mockito.verify((Object)this.updateCommand, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void testNewDivider() {
        this.navTreeEditor.setOnUpdateCommand(this.updateCommand);
        this.navTreeEditor.edit(this.NAV_TREE);
        this.navTreeEditor.collapse();
        Assert.assertFalse((boolean)this.navTreeEditor.isExpanded());
        Mockito.reset((Object[])new NavTreeEditorView[]{this.view});
        this.navTreeEditor.newDivider();
        Assert.assertTrue((boolean)this.navTreeEditor.isExpanded());
        Assert.assertEquals((long)((NavGroup)this.navTreeEditor.getNavItem()).getChildren().size(), (long)3L);
        ((NavTreeEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addChild((IsElement)Mockito.any());
        ((Command)Mockito.verify((Object)this.updateCommand)).execute();
    }

    @Test
    public void testSaveAndCancel() {
        this.navTreeEditor.edit(this.NAV_TREE);
        NavItemEditor newEditor = this.navTreeEditor.newGroup();
        newEditor.onChangesOk();
        this.navTreeEditor.onSaveClicked();
        NavTree navTree = this.navTreeEditor.getNavTree();
        Assert.assertNotNull((Object)navTree.getItemById(newEditor.getNavItem().getId()));
    }

    @Test
    public void testNewPerspectiveActionAvailable() {
        NavItemEditor navItemEditor = this.navTreeEditor.newGroup();
        Assert.assertTrue((boolean)navItemEditor.isNewPerspectiveEnabled());
        this.perspectivePlugins.clear();
        Assert.assertFalse((boolean)navItemEditor.isNewPerspectiveEnabled());
    }

    @Test
    public void testCancelLastEditedItem() {
        NavItemEditor navItemEditorA = (NavItemEditor)Mockito.mock(NavItemEditor.class);
        this.navTreeEditor.onItemEditStarted(new NavItemEditStartedEvent(navItemEditorA));
        Assert.assertEquals((Object)this.navTreeEditor.getCurrentlyEditedItem(), (Object)navItemEditorA);
        this.navTreeEditor.onItemEditStarted(new NavItemEditStartedEvent(navItemEditorA));
        ((NavItemEditor)Mockito.verify((Object)navItemEditorA, (VerificationMode)Mockito.never())).cancelEdition();
        NavItemEditor navItemEditorB = (NavItemEditor)Mockito.mock(NavItemEditor.class);
        this.navTreeEditor.onItemEditStarted(new NavItemEditStartedEvent(navItemEditorB));
        Assert.assertEquals((Object)this.navTreeEditor.getCurrentlyEditedItem(), (Object)navItemEditorB);
        ((NavItemEditor)Mockito.verify((Object)navItemEditorA)).cancelEdition();
    }

    @Test
    public void testEditIsNotInvokedTwiceAfterCancel() {
        this.navTreeEditor.edit(this.NAV_TREE);
        Mockito.reset((Object[])new NavItemDefaultEditor[]{this.navItemEditor});
        this.navItemEditor.startEdition();
        this.navItemEditor.cancelEdition();
        ((NavItemDefaultEditor)Mockito.verify((Object)this.navItemEditor, (VerificationMode)Mockito.times((int)1))).edit((NavItem)Mockito.any());
    }

    @Test
    public void testOnNewTreeClicked() {
        this.navTreeEditor.newTree();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).saveDefaultNavTree();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).newGroup();
    }

    @Test
    public void testSaveDefaultNavTreeWhenNavigationManagerDoesNotHaveNavTree() {
        ((NavigationManager)Mockito.doReturn((Object)false).when((Object)this.navigationManager)).hasNavTree();
        this.navTreeEditor.saveDefaultNavTree();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).showLoading();
        ((NavigationManager)Mockito.verify((Object)this.navigationManager)).saveNavTree((NavTree)Mockito.any(), (Command)Mockito.any(Command.class));
    }

    @Test
    public void testSaveDefaultNavTreeWhenNavigationManagerHasNavTree() {
        ((NavigationManager)Mockito.doReturn((Object)true).when((Object)this.navigationManager)).hasNavTree();
        this.navTreeEditor.saveDefaultNavTree();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor, (VerificationMode)Mockito.never())).showLoading();
        ((NavigationManager)Mockito.verify((Object)this.navigationManager, (VerificationMode)Mockito.never())).saveNavTree((NavTree)Mockito.any(NavTree.class), (Command)Mockito.any(Command.class));
    }

    @Test
    public void testShowLoading() {
        this.navTreeEditor.showLoading();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox)).show();
    }

    @Test
    public void testHideLoading() {
        this.navTreeEditor.hideLoading();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox)).hide();
    }
}

