/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation;

import java.util.Arrays;
import java.util.List;
import org.dashbuilder.client.navigation.widget.NavComponentConfigModal;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class NavComponentConfigModalTest {
    @Mock
    NavComponentConfigModal.View view;
    @Mock
    Command onOk;
    NavTree tree;
    NavComponentConfigModal presenter;

    @Before
    public void setUp() throws Exception {
        this.tree = new NavTreeBuilder().item("H1", "H1", null, false).divider().group("A", "A", null, false).item("A1", "A1", null, false).item("A2", "A2", null, false).group("B", "B", null, false).group("C", "C", null, false).build();
        this.presenter = new NavComponentConfigModal(this.view);
        this.presenter.setOnOk(this.onOk);
    }

    @Test
    public void testInitDefault() {
        this.presenter.setNavGroup(this.tree.getRootItems(), null);
        this.presenter.show();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).clearNavGroupItems();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).setNavGroupSelection((String)Mockito.eq((Object)"A"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"A>B"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"A>B>C"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testInitSelected() {
        this.presenter.setNavGroup(this.tree.getRootItems(), "B");
        this.presenter.show();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).clearNavGroupItems();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).setNavGroupSelection((String)Mockito.eq((Object)"A>B"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"A"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"A>B>C"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testSelectItem() {
        this.presenter.setNavGroup(this.tree.getRootItems(), "A");
        this.presenter.show();
        Mockito.reset((Object[])new NavComponentConfigModal.View[]{this.view});
        this.presenter.onGroupSelected("B");
        Assert.assertEquals((Object)this.presenter.getGroupId(), (Object)"B");
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).clearNavGroupItems();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).setNavGroupSelection((String)Mockito.eq((Object)"A>B"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"A"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addNavGroupItem((String)Mockito.eq((Object)"A>B>C"), (Command)Mockito.any());
    }

    @Test
    public void testDefaultItemsPerGroup() {
        this.presenter.setNavGroup(this.tree.getRootItems(), "A");
        this.presenter.show();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).setDefaultNavItemEnabled(true);
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).clearDefaultItems();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addDefaultItem((String)Mockito.eq((Object)"A>A1"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addDefaultItem((String)Mockito.eq((Object)"A>A2"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addDefaultItem((String)Mockito.eq((Object)"A>B"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addDefaultItem((String)Mockito.eq((Object)"C"), (Command)Mockito.any());
        Mockito.reset((Object[])new NavComponentConfigModal.View[]{this.view});
        this.presenter.onGroupSelected("C");
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).setDefaultNavItemEnabled(true);
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).clearDefaultItems();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addDefaultItem(Mockito.anyString(), (Command)Mockito.any());
    }

    @Test
    public void testTargetDivList() {
        List<String> targetDivIdList = Arrays.asList("div1", "div2");
        this.presenter.setTargetDivIdList(targetDivIdList);
        this.presenter.show();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).clearTargetDivItems();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).setTargetDivSelection((String)Mockito.eq((Object)"div1"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addTargetDivItem((String)Mockito.eq((Object)"div2"), (Command)Mockito.any());
        Assert.assertEquals((Object)this.presenter.getTargetDivId(), (Object)"div1");
        Mockito.reset((Object[])new NavComponentConfigModal.View[]{this.view});
        this.presenter.setTargetDiv("t");
        this.presenter.show();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).clearTargetDivItems();
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).setTargetDivSelection((String)Mockito.eq((Object)"div1"), (Command)Mockito.any());
        ((NavComponentConfigModal.View)Mockito.verify((Object)this.view)).addTargetDivItem((String)Mockito.eq((Object)"div2"), (Command)Mockito.any());
        Assert.assertEquals((Object)this.presenter.getTargetDivId(), (Object)"div1");
    }
}

