/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.navigation.event.NavItemEditCancelledEvent;
import org.dashbuilder.client.navigation.event.NavItemEditStartedEvent;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.editor.NavItemDefaultEditor;
import org.dashbuilder.client.navigation.widget.editor.NavItemDefaultEditorView;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditor;
import org.dashbuilder.client.navigation.widget.editor.TargetPerspectiveEditor;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class NavItemEditorTest {
    @Mock
    NavItemDefaultEditorView view;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    PerspectiveTreeProvider perspectiveTreeProvider;
    @Mock
    EventSourceMock<NavItemEditStartedEvent> navItemEditStartedEvent;
    @Mock
    EventSourceMock<NavItemEditCancelledEvent> navItemEditCancelledEvent;
    @Mock
    PlaceManager placeManager;
    @Mock
    TargetPerspectiveEditor targetPerspectiveEditor;
    @Mock
    PerspectivePluginManager perspectivePluginManager;
    @Mock
    Command updateCommand;
    NavItemEditor presenter;
    static final String NEW_PERSPECTIVE_NAME = "- New Perspective -";

    @Before
    public void setUp() throws Exception {
        this.presenter = new NavItemDefaultEditor(this.view, this.beanManager, this.placeManager, this.perspectiveTreeProvider, this.targetPerspectiveEditor, this.perspectivePluginManager, this.navItemEditStartedEvent, this.navItemEditCancelledEvent);
        Mockito.when((Object)this.view.i18nNewItemName("Perspective")).thenReturn((Object)NEW_PERSPECTIVE_NAME);
        this.presenter.getSettings().setLiteralPerspective("Perspective");
        ((TargetPerspectiveEditor)Mockito.doAnswer(invocationOnMock -> invocationOnMock.getArguments()[0]).when((Object)this.targetPerspectiveEditor)).getPerspectiveName(Mockito.anyString());
    }

    @Test
    public void testChangeGroup() {
        NavGroup navGroup = NavFactory.get().createNavGroup();
        navGroup.setId("id");
        navGroup.setName("name");
        navGroup.setDescription("description");
        navGroup.setModifiable(true);
        this.presenter.setOnUpdateCommand(this.updateCommand);
        this.presenter.edit((NavItem)navGroup);
        Mockito.when((Object)this.view.getItemName()).thenReturn((Object)"name");
        this.presenter.onChangesOk();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).finishItemEdition();
        ((Command)Mockito.verify((Object)this.updateCommand)).execute();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"name");
        Mockito.reset((Object[])new Command[]{this.updateCommand});
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        Mockito.when((Object)this.view.getItemName()).thenReturn((Object)"  \t   ");
        this.presenter.onChangesOk();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).finishItemEdition();
        ((Command)Mockito.verify((Object)this.updateCommand, (VerificationMode)Mockito.never())).execute();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"name");
        Mockito.reset((Object[])new Command[]{this.updateCommand});
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        Mockito.when((Object)this.view.getItemName()).thenReturn((Object)"newName");
        this.presenter.onChangesOk();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).finishItemEdition();
        ((Command)Mockito.verify((Object)this.updateCommand)).execute();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"newName");
    }

    @Test
    public void testChangePerspective() {
        NavItem navItem = NavFactory.get().createNavItem();
        NavWorkbenchCtx navCtxA = NavWorkbenchCtx.perspective((String)"A");
        NavWorkbenchCtx navCtxB = NavWorkbenchCtx.perspective((String)"B");
        navItem.setContext(navCtxA.toString());
        navItem.setId("id");
        navItem.setName("name");
        navItem.setDescription("description");
        navItem.setModifiable(true);
        this.presenter.setOnUpdateCommand(this.updateCommand);
        this.presenter.edit(navItem);
        Mockito.when((Object)this.view.getItemName()).thenReturn((Object)"name");
        this.presenter.onChangesOk();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).finishItemEdition();
        Mockito.reset((Object[])new Command[]{this.updateCommand});
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        Mockito.when((Object)this.view.getItemName()).thenReturn((Object)"name");
        Mockito.when((Object)this.targetPerspectiveEditor.getPerspectiveId()).thenReturn((Object)"B");
        this.presenter.onChangesOk();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).finishItemEdition();
        ((Command)Mockito.verify((Object)this.updateCommand)).execute();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"name");
        Assert.assertEquals((Object)this.presenter.getNavItem().getContext(), (Object)navCtxB.toString());
        navItem.setContext(navCtxA.toString());
        this.presenter.edit(navItem);
        Mockito.reset((Object[])new Command[]{this.updateCommand});
        Mockito.reset((Object[])new TargetPerspectiveEditor[]{this.targetPerspectiveEditor});
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        Mockito.when((Object)this.view.getItemName()).thenReturn((Object)"newName");
        Mockito.when((Object)this.targetPerspectiveEditor.getPerspectiveId()).thenReturn((Object)"B");
        this.presenter.cancelEdition();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).finishItemEdition();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemName("name");
        ((TargetPerspectiveEditor)Mockito.verify((Object)this.targetPerspectiveEditor)).setPerspectiveId("A");
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"name");
        Assert.assertEquals((Object)this.presenter.getNavItem().getContext(), (Object)navCtxA.toString());
    }

    @Test
    public void testEditGroup() {
        NavGroup navGroup = NavFactory.get().createNavGroup();
        navGroup.setId("id");
        navGroup.setName("name");
        navGroup.setDescription("description");
        navGroup.setModifiable(false);
        this.presenter.edit((NavItem)navGroup);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).clearChildren();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).clearCommands();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemName("name");
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemDescription("description");
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemEditable(false);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemType(NavItemEditor.ItemType.GROUP);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).addCommand((String)Mockito.any(), (Command)Mockito.any());
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setContextWidget((IsElement)Mockito.any());
    }

    @Test
    public void testEditDivider() {
        NavDivider divider = NavFactory.get().createDivider();
        divider.setId("id");
        divider.setName("name");
        divider.setDescription("description");
        divider.setModifiable(true);
        this.presenter.edit((NavItem)divider);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).clearChildren();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).clearCommands();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemName("name");
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemDescription("description");
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemEditable(false);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemType(NavItemEditor.ItemType.DIVIDER);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).addCommand((String)Mockito.any(), (Command)Mockito.any());
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setContextWidget((IsElement)Mockito.any());
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        this.presenter.startEdition();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).startItemEdition();
    }

    @Test
    public void testEditPerspective() {
        NavItem navItem = NavFactory.get().createNavItem();
        navItem.setModifiable(false);
        navItem.setContext(NavWorkbenchCtx.perspective((String)"p1").toString());
        this.presenter.edit(navItem);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).clearChildren();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).clearCommands();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemEditable(false);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemType(NavItemEditor.ItemType.PERSPECTIVE);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).addCommand((String)Mockito.any(), (Command)Mockito.any());
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setContextWidget((IsElement)this.targetPerspectiveEditor);
    }

    @Test
    public void testCommandsAvailability() {
        this.presenter.setMoveUpEnabled(false);
        this.presenter.setMoveDownEnabled(false);
        NavGroup navGroup = NavFactory.get().createNavGroup();
        navGroup.setModifiable(false);
        this.presenter.edit((NavItem)navGroup);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        navGroup.setModifiable(true);
        this.presenter.edit((NavItem)navGroup);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        NavItem navItem = NavFactory.get().createNavItem();
        navItem.setContext(NavWorkbenchCtx.perspective((String)"p1").toString());
        navItem.setModifiable(false);
        this.presenter.edit(navItem);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        navItem.setModifiable(true);
        this.presenter.edit(navItem);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemEditable(true);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemDeletable(true);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        NavDivider navDivider = NavFactory.get().createDivider();
        navDivider.setModifiable(true);
        this.presenter.edit((NavItem)navDivider);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemEditable(false);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemDeletable(true);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        navDivider.setModifiable(false);
        this.presenter.edit((NavItem)navDivider);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        this.presenter.setMoveUpEnabled(true);
        this.presenter.setMoveDownEnabled(true);
        this.presenter.edit(navItem);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        this.presenter.edit((NavItem)navDivider);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        this.presenter.edit((NavItem)navGroup);
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setCommandsEnabled(true);
    }

    @Test
    public void testItemNameFromPerspective() {
        NavItem navItem = NavFactory.get().createNavItem();
        navItem.setId("id");
        navItem.setName("name");
        navItem.setModifiable(true);
        navItem.setContext(NavWorkbenchCtx.perspective((String)"A").toString());
        this.presenter.edit(navItem);
        this.presenter.startEdition();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemName("name");
        Mockito.when((Object)this.targetPerspectiveEditor.getPerspectiveId()).thenReturn((Object)"B");
        this.presenter.onTargetPerspectiveUpdated();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setItemName("B");
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        navItem.setName(NEW_PERSPECTIVE_NAME);
        this.presenter.edit(navItem);
        this.presenter.startEdition();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemName("A");
        Mockito.when((Object)this.targetPerspectiveEditor.getPerspectiveId()).thenReturn((Object)"B");
        this.presenter.onTargetPerspectiveUpdated();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view)).setItemName("B");
        Mockito.reset((Object[])new NavItemDefaultEditorView[]{this.view});
        this.presenter.onItemNameChanged();
        this.presenter.onTargetPerspectiveUpdated();
        ((NavItemDefaultEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setItemName("B");
    }

    @Test
    public void testCancelRestoresLastBackup() {
        NavItem navItem = NavFactory.get().createNavItem();
        navItem.setId("id");
        navItem.setName("name");
        navItem.setModifiable(true);
        navItem.setContext(NavWorkbenchCtx.perspective((String)"A").toString());
        Mockito.when((Object)this.targetPerspectiveEditor.getPerspectiveId()).thenReturn((Object)"A");
        this.presenter.edit(navItem);
        this.presenter.startEdition();
        Mockito.when((Object)this.view.getItemName()).thenReturn((Object)"newName");
        this.presenter.onChangesOk();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"newName");
        this.presenter.startEdition();
        this.presenter.cancelEdition();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"newName");
        this.presenter.edit(navItem);
        this.presenter.startEdition();
        this.presenter.cancelEdition();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"name");
    }

    @Test
    public void testBackupIsNotUpdatedOnError() {
        NavItem navItem = NavFactory.get().createNavItem();
        navItem.setId("id");
        navItem.setName("name");
        navItem.setModifiable(true);
        navItem.setContext(NavWorkbenchCtx.perspective((String)"A").toString());
        this.presenter.edit(navItem);
        this.presenter.startEdition();
        Mockito.when((Object)this.view.getItemName()).thenReturn((Object)"newName");
        this.presenter.onChangesOk();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"newName");
        this.presenter.cancelEdition();
        Assert.assertEquals((Object)this.presenter.getNavItem().getName(), (Object)"name");
    }
}

