/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.NavComponentConfigModal;
import org.gwtbootstrap3.client.ui.Modal;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.TemplateWidgetMapper;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.ButtonPressed;
import org.uberfire.mvp.Command;

@Templated
public class NavComponentConfigModalView
implements NavComponentConfigModal.View {
    NavComponentConfigModal presenter;
    BaseModal modal;
    ButtonPressed buttonPressed = ButtonPressed.CLOSE;
    @Inject
    @DataField
    Div body;
    @Inject
    @DataField
    Div footer;
    @Inject
    @DataField
    Div navGroupDiv;
    @Inject
    @DataField
    Span navGroupLabel;
    @DataField
    @Inject
    Span navGroupHelp;
    @DataField
    @Inject
    Span navGroupSelection;
    @DataField
    @Inject
    UnorderedList navGroupItems;
    @Inject
    @DataField
    Div defaultItemDiv;
    @Inject
    @DataField
    Span defaultItemLabel;
    @DataField
    @Inject
    Span defaultItemHelp;
    @DataField
    @Inject
    Span defaultItemSelection;
    @DataField
    @Inject
    UnorderedList defaultItems;
    @Inject
    @DataField
    Div targetDivDiv;
    @Inject
    @DataField
    Span targetDivLabel;
    @DataField
    @Inject
    Span targetDivHelp;
    @DataField
    @Inject
    Span targetDivSelection;
    @DataField
    @Inject
    UnorderedList targetDivItems;

    public void init(NavComponentConfigModal presenter) {
        this.presenter = presenter;
        this.navGroupLabel.setTextContent(NavigationConstants.INSTANCE.navGroupLabel());
        this.navGroupHelp.setTitle(NavigationConstants.INSTANCE.navGroupHelp());
        this.navGroupSelection.setTextContent(NavigationConstants.INSTANCE.navGroupSelectorHint());
        this.defaultItemLabel.setTextContent(NavigationConstants.INSTANCE.defaultItemLabel());
        this.defaultItemHelp.setTitle(NavigationConstants.INSTANCE.defaultItemHelp());
        this.defaultItemSelection.setTextContent(NavigationConstants.INSTANCE.defaultItemSelectorHint());
        this.targetDivLabel.setTextContent(NavigationConstants.INSTANCE.targetDivLabel());
        this.targetDivHelp.setTitle(NavigationConstants.INSTANCE.targetDivHelp());
        this.targetDivSelection.setTextContent(NavigationConstants.INSTANCE.targetDivSelectorHint());
        this.modal = new CommonModalBuilder().addHeader(NavigationConstants.INSTANCE.navConfigHeader()).addBody((HTMLElement)this.body).addFooter((HTMLElement)this.footer).build();
        this.modal.addHiddenHandler(hiddenEvent -> {
            if (ButtonPressed.CLOSE.equals((Object)this.buttonPressed)) {
                presenter.onCancel();
            }
        });
        this.modal.setWidth("960px");
    }

    public Modal getModal() {
        return this.modal;
    }

    public Widget asWidget() {
        return TemplateWidgetMapper.get((Object)this.modal);
    }

    @Override
    public void show() {
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void setNavGroupEnabled(boolean enabled) {
        this.navGroupDiv.setClassName("form-group" + (enabled ? "" : " uf-navconfig-disabled"));
    }

    @Override
    public void clearNavGroupItems() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.navGroupItems);
        this.navGroupSelection.setTextContent(NavigationConstants.INSTANCE.navGroupSelectorHint());
    }

    @Override
    public void setNavGroupHelpText(String text) {
        this.navGroupHelp.setTitle(text);
    }

    @Override
    public void setNavGroupSelection(String name, Command onReset) {
        this.navGroupSelection.setTextContent(name);
        this.addItem(this.navGroupItems, name, true, onReset);
    }

    @Override
    public void addNavGroupItem(String name, Command onSelect) {
        this.addItem(this.navGroupItems, name, false, onSelect);
    }

    @Override
    public void setDefaultNavItemVisible(boolean enabled) {
        this.defaultItemDiv.setHidden(!enabled);
    }

    @Override
    public void setDefaultNavItemEnabled(boolean enabled) {
        this.defaultItemDiv.setClassName("form-group" + (enabled ? "" : " uf-navconfig-disabled"));
    }

    @Override
    public void clearDefaultItems() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.defaultItems);
        this.defaultItemSelection.setTextContent(NavigationConstants.INSTANCE.defaultItemSelectorHint());
    }

    @Override
    public void defaultItemsNotFound() {
        this.clearDefaultItems();
        this.addDefaultItem(NavigationConstants.INSTANCE.defaultItemsNotFound(), () -> {});
    }

    @Override
    public void setDefaultItemSelection(String name, Command onReset) {
        this.defaultItemSelection.setTextContent(name);
        this.addItem(this.defaultItems, name, true, onReset);
    }

    @Override
    public void addDefaultItem(String name, Command onSelect) {
        this.addItem(this.defaultItems, name, false, onSelect);
    }

    @Override
    public void setTargetDivVisible(boolean enabled) {
        this.targetDivDiv.setHidden(!enabled);
    }

    @Override
    public void clearTargetDivItems() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.targetDivItems);
        this.targetDivSelection.setTextContent(NavigationConstants.INSTANCE.targetDivSelectorHint());
    }

    @Override
    public void targetDivsNotFound() {
        this.clearTargetDivItems();
        this.addTargetDivItem(NavigationConstants.INSTANCE.targetDivsNotFound(), () -> {});
    }

    @Override
    public void addTargetDivItem(String name, Command onSelect) {
        this.addItem(this.targetDivItems, name, false, onSelect);
    }

    @Override
    public void setTargetDivSelection(String name, Command onReset) {
        this.targetDivSelection.setTextContent(name);
        this.addItem(this.targetDivItems, name, true, onReset);
    }

    private void addItem(UnorderedList unorderedList, String name, boolean selected, Command onSelect) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setInnerText(name);
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((Node)anchor);
        li.setClassName(selected ? "selected" : "");
        unorderedList.appendChild((org.jboss.errai.common.client.dom.Node)li);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                onSelect.execute();
            }
        });
    }

    @SinkNative(value=1)
    @EventHandler(value={"okButton"})
    public void okClick(Event event) {
        this.buttonPressed = ButtonPressed.OK;
        this.presenter.onOk();
    }

    @SinkNative(value=1)
    @EventHandler(value={"cancelButton"})
    public void cancelClick(Event event) {
        this.buttonPressed = ButtonPressed.CANCEL;
        this.presenter.onCancel();
    }
}

