/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.DomGlobal;
import elemental2.dom.MutationObserver;
import elemental2.dom.MutationObserverInit;
import elemental2.dom.Node;
import jsinterop.base.Js;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.displayer.client.AbstractGwtDisplayerView;
import org.dashbuilder.renderer.c3.client.C3Displayer;
import org.dashbuilder.renderer.c3.client.jsbinding.C3;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Chart;
import org.dashbuilder.renderer.c3.client.jsbinding.C3ChartConf;
import org.dashbuilder.renderer.c3.client.resources.i18n.C3DisplayerConstants;
import org.dashbuilder.renderer.c3.mutationobserver.MutationObserverFactory;
import org.gwtbootstrap3.client.ui.Label;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;

public abstract class C3DisplayerView<P extends C3Displayer>
extends AbstractGwtDisplayerView<P>
implements C3Displayer.View<P> {
    private Panel container = (Panel)GWT.create(FlowPanel.class);
    private Panel filterPanel = (Panel)GWT.create(FlowPanel.class);
    protected Panel displayerPanel = (Panel)GWT.create(FlowPanel.class);
    private HTML titleHtml = (HTML)GWT.create(HTML.class);
    private int width;
    private int height;
    protected C3Chart chart;

    public void init(P presenter) {
        super.setPresenter(presenter);
        super.setVisualization((IsWidget)this.container);
        this.container.add((Widget)this.titleHtml);
        this.container.add((Widget)this.filterPanel);
        this.container.add((Widget)this.displayerPanel);
        this.filterPanel.getElement().setAttribute("cellpadding", "2");
    }

    @Override
    public void updateChart(C3ChartConf conf) {
        this.displayerPanel.clear();
        conf.setBindto(this.displayerPanel.getElement());
        this.chart = C3.generate(conf);
    }

    @Override
    public String getGroupsTitle() {
        return C3DisplayerConstants.INSTANCE.common_Categories();
    }

    @Override
    public String getColumnsTitle() {
        return C3DisplayerConstants.INSTANCE.common_Series();
    }

    @Override
    public void showTitle(String title) {
        this.titleHtml.setText(title);
    }

    @Override
    public void setFilterLabelSet(FilterLabelSet widget) {
        HTMLElement element = widget.getElement();
        element.getStyle().setProperty("position", "absolute");
        element.getStyle().setProperty("z-index", "10");
        this.filterPanel.clear();
        this.filterPanel.add((Widget)ElementWrapperWidget.getWidget((HTMLElement)element));
    }

    @Override
    public void setBackgroundColor(String color) {
        ((Element)this.chart.getElement().getElementsByTagName("svg").getItem(0)).getStyle().setBackgroundColor(color);
    }

    @Override
    public void noData() {
        FlowPanel noDataPanel = (FlowPanel)GWT.create(FlowPanel.class);
        noDataPanel.setWidth(this.width + "px");
        noDataPanel.setHeight(this.height + "px");
        Label lblNoData = (Label)GWT.create(Label.class);
        lblNoData.setText(C3DisplayerConstants.INSTANCE.common_noData());
        noDataPanel.add((Widget)lblNoData);
        this.displayerPanel.clear();
        this.displayerPanel.add((Widget)noDataPanel);
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void setResizable(int maxWidth, int maxHeight) {
        this.displayerPanel.setWidth("100%");
        this.displayerPanel.getElement().getStyle().setProperty("maxWidth", maxWidth + "px");
        this.displayerPanel.getElement().getStyle().setProperty("maxHeight", maxHeight + "px");
        this.registerMutationObserver();
    }

    private void registerMutationObserver() {
        MutationObserver observer = new MutationObserver((records, obs) -> {
            Node elementalNode = (Node)Js.cast((Object)this.displayerPanel.getElement());
            if (DomGlobal.document.body.contains(elementalNode)) {
                if (this.chart != null) {
                    this.chart.flush();
                }
                obs.disconnect();
            }
            return null;
        });
        MutationObserverInit options = new MutationObserverFactory().mutationObserverInit();
        options.childList = true;
        observer.observe((Node)DomGlobal.document.body, options);
    }
}

