/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.meter;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.c3.client.C3Displayer;
import org.dashbuilder.renderer.c3.client.jsbinding.C3ChartConf;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Color;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Gauge;
import org.dashbuilder.renderer.c3.client.jsbinding.C3JsTypesFactory;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Threshold;

@Dependent
public class C3MeterChartDisplayer
extends C3Displayer<C3Displayer.View> {
    private View view;

    @Inject
    public C3MeterChartDisplayer(View view, FilterLabelSet filterLabelSet, C3JsTypesFactory factory) {
        super(filterLabelSet, factory);
        this.view = view;
        this.view.init((Object)this);
    }

    @Override
    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(false).setGroupAllowed(true).setGroupColumn(true).setMaxColumns(2)).setMinColumns(1)).setExtraColumnsAllowed(false)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle()).setFunctionRequired(true).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.NUMBER}, {ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.METER_GROUP);
    }

    public View getView() {
        return this.view;
    }

    @Override
    protected C3ChartConf buildConfiguration() {
        C3ChartConf conf = super.buildConfiguration();
        C3Gauge gaugeConf = this.createGauge();
        conf.setGauge(gaugeConf);
        return conf;
    }

    @Override
    protected String[][] createSeries() {
        List columns = this.dataSet.getColumns();
        String[][] output = new String[0][0];
        if (columns.size() == 1) {
            output = new String[][]{this.extractSingleColumnValues((DataColumn)columns.get(0))};
        } else {
            DataColumn groupsColumn = (DataColumn)columns.get(0);
            DataColumn valuesColumn = (DataColumn)columns.get(1);
            output = this.extractGroupingValues(groupsColumn, valuesColumn);
        }
        return output;
    }

    @Override
    protected C3Color createColor() {
        C3Color color = super.createColor();
        int[] thresholdValues = new int[]{(int)this.displayerSettings.getMeterWarning(), (int)this.displayerSettings.getMeterCritical(), (int)this.displayerSettings.getMeterEnd()};
        C3Threshold c3Threshold = this.factory.c3Threshold(thresholdValues);
        color.setPattern(this.getView().getColorPattern());
        color.setThreshold(c3Threshold);
        return color;
    }

    private C3Gauge createGauge() {
        int meterStart = (int)this.displayerSettings.getMeterStart();
        int meterEnd = (int)this.displayerSettings.getMeterEnd();
        return this.factory.c3Gauge(meterStart, meterEnd);
    }

    String[][] extractGroupingValues(DataColumn groupsColumn, DataColumn valuesColumn) {
        int n = groupsColumn.getValues().size();
        String[][] output = new String[n][2];
        for (int i = 0; i < n; ++i) {
            Object group = groupsColumn.getValues().get(i);
            Object value = valuesColumn.getValues().get(i);
            output[i][0] = this.columnValueToString(group);
            output[i][1] = this.columnValueToString(value);
        }
        return output;
    }

    String[] extractSingleColumnValues(DataColumn dataColumn) {
        List values = dataColumn.getValues();
        String[] data = new String[values.size() + 1];
        data[0] = dataColumn.getId();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            data[i + 1] = this.columnValueToString(value);
        }
        return data;
    }

    public static interface View
    extends C3Displayer.View<C3MeterChartDisplayer> {
        public String[] getColorPattern();
    }
}

