/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.pie;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.c3.client.C3Displayer;
import org.dashbuilder.renderer.c3.client.charts.CommonC3DisplayerConstants;
import org.dashbuilder.renderer.c3.client.jsbinding.C3AxisX;
import org.dashbuilder.renderer.c3.client.jsbinding.C3JsTypesFactory;

@Dependent
public class C3PieChartDisplayer
extends C3Displayer<View> {
    private View view;

    @Inject
    public C3PieChartDisplayer(View view, FilterLabelSet filterLabelSet, C3JsTypesFactory builder) {
        super(filterLabelSet, builder);
        this.view = view;
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public C3PieChartDisplayer donut() {
        this.getView().setShowAsDonut(true);
        return this;
    }

    @Override
    protected String[][] createSeries() {
        List columns = this.dataSet.getColumns();
        String[][] data = null;
        DataColumn categoriesColumn = (DataColumn)columns.get(0);
        List values = categoriesColumn.getValues();
        data = new String[values.size()][];
        for (int i = 0; i < values.size(); ++i) {
            String[] seriesValues = new String[columns.size()];
            seriesValues[0] = super.formatValue(values.get(i), categoriesColumn);
            for (int j = 1; j < columns.size(); ++j) {
                DataColumn dataColumn = (DataColumn)columns.get(j);
                seriesValues[j] = dataColumn.getValues().get(i).toString();
            }
            data[i] = seriesValues;
        }
        return data;
    }

    @Override
    protected C3AxisX createAxisX() {
        return null;
    }

    @Override
    protected String[] createCategories() {
        return null;
    }

    @Override
    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(2)).setMinColumns(2)).setExtraColumnsAllowed(false)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new CommonC3DisplayerConstants(lookupConstraints).create().supportsAttribute(DisplayerAttributeDef.SUBTYPE);
    }

    public static interface View
    extends C3Displayer.View<C3PieChartDisplayer> {
        public void setShowAsDonut(boolean var1);
    }
}

