/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client;

import java.util.List;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.LineChartSettingsBuilderImpl;
import org.dashbuilder.renderer.c3.client.C3BaseTest;
import org.dashbuilder.renderer.c3.client.charts.line.C3LineChartDisplayer;
import org.dashbuilder.renderer.c3.client.jsbinding.C3AxisX;
import org.dashbuilder.renderer.c3.client.jsbinding.C3AxisY;
import org.dashbuilder.renderer.c3.client.jsbinding.C3ChartConf;
import org.dashbuilder.renderer.c3.client.jsbinding.C3JsTypesFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class C3DisplayerTest
extends C3BaseTest {
    private static final boolean RECEIVE_NOTIFICATION = true;
    private static final String LEGEND_POSITION = "right";
    private static final int SIZE = 300;
    private static final String TITLE = "Title";
    private static final String BLACK = "black";
    DisplayerSettings simpleSettings = ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().dataset("expenses")).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM)).width(300)).height(300)).title("Title")).backgroundColor("black")).titleVisible(true)).legendOn("right")).filterOn(true, true, true)).buildSettings();
    private C3LineChartDisplayer displayer;

    @Before
    public void conf() {
        this.displayer = this.c3LineChartDisplayer(this.simpleSettings);
        this.displayer.draw();
    }

    @Test
    public void c3ConfigurationTest() {
        ((C3JsTypesFactory)Mockito.verify((Object)this.c3Factory)).c3ChartSize(300.0, 300.0);
        ((C3JsTypesFactory)Mockito.verify((Object)this.c3Factory)).c3AxisInfo(Matchers.eq((boolean)false), (C3AxisX)Matchers.any(), (C3AxisY)Matchers.any());
        ((C3JsTypesFactory)Mockito.verify((Object)this.c3Factory)).c3Legend(true, LEGEND_POSITION);
        ((C3JsTypesFactory)Mockito.verify((Object)this.c3Factory)).c3Selection(true, true, false);
    }

    @Test
    public void viewParametersTest() {
        C3LineChartDisplayer.View view = this.displayer.getView();
        ((C3LineChartDisplayer.View)Mockito.verify((Object)view)).init(Matchers.any());
        ((C3LineChartDisplayer.View)Mockito.verify((Object)view)).updateChart((C3ChartConf)Matchers.any(C3ChartConf.class));
        ((C3LineChartDisplayer.View)Mockito.verify((Object)view)).showTitle(TITLE);
        ((C3LineChartDisplayer.View)Mockito.verify((Object)view)).setBackgroundColor(BLACK);
    }

    @Test
    public void c3DataTest() {
        DataSet lastDataSet = this.displayer.getDataSetHandler().getLastDataSet();
        List categories = ((DataColumn)lastDataSet.getColumns().get(0)).getValues();
        DataColumn seriesColumn = (DataColumn)lastDataSet.getColumns().get(1);
        String[][] createdSeries = this.displayer.createSeries();
        Assert.assertArrayEquals((Object[])this.displayer.createCategories(), (Object[])categories.toArray());
        Assert.assertEquals((long)createdSeries[0].length, (long)(seriesColumn.getValues().size() + 1));
        Assert.assertEquals((Object)createdSeries[0][0], (Object)seriesColumn.getId());
    }

    @Test
    public void c3NoData() {
        DisplayerSettings noData = ((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)DisplayerSettingsFactory.newLineChartSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM)).buildSettings();
        this.displayer = this.c3LineChartDisplayer(noData);
        this.displayer.draw();
        C3LineChartDisplayer.View view = this.displayer.getView();
        ((C3LineChartDisplayer.View)Mockito.verify((Object)view)).noData();
    }
}

