/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client;

import java.util.List;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.renderer.c3.client.C3Displayer;
import org.dashbuilder.renderer.c3.client.jsbinding.C3AxisInfo;
import org.dashbuilder.renderer.c3.client.jsbinding.C3AxisLabel;
import org.dashbuilder.renderer.c3.client.jsbinding.C3ChartConf;
import org.dashbuilder.renderer.c3.client.jsbinding.C3JsTypesFactory;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Tick;

public abstract class C3XYDisplayer<V extends C3Displayer.View>
extends C3Displayer {
    private static final String DEFAULT_LABEL_POS = "outer-center";
    private boolean stacked;

    public C3XYDisplayer(FilterLabelSet filterLabelSet, C3JsTypesFactory builder) {
        super(filterLabelSet, builder);
    }

    @Override
    protected C3ChartConf buildConfiguration() {
        C3ChartConf conf = super.buildConfiguration();
        this.applyPropertiesToAxes(conf.getAxis());
        return conf;
    }

    @Override
    protected C3Tick createTickY() {
        return this.factory.createC3Tick(f -> {
            List columns = this.dataSet.getColumns();
            if (columns.size() > 1) {
                DataColumn dataColumn = (DataColumn)columns.get(1);
                f = super.formatValue((Object)f, dataColumn);
            }
            return f;
        });
    }

    private void applyPropertiesToAxes(C3AxisInfo axis) {
        axis.getX().getTick().setRotate(this.displayerSettings.getXAxisLabelsAngle());
        if (this.displayerSettings.isXAxisShowLabels()) {
            C3AxisLabel xLabel = this.factory.createC3Label(this.displayerSettings.getXAxisTitle(), DEFAULT_LABEL_POS);
            axis.getX().setLabel(xLabel);
        }
        if (this.displayerSettings.isYAxisShowLabels()) {
            C3AxisLabel yLabel = this.factory.createC3Label(this.displayerSettings.getYAxisTitle(), DEFAULT_LABEL_POS);
            axis.getY().setLabel(yLabel);
        }
    }

    protected String[][] stackedGroups() {
        String[][] groups = new String[1][];
        groups[0] = (String[])this.dataSet.getColumns().stream().skip(1L).map(arg_0 -> ((DisplayerSettings)this.displayerSettings).getColumnSettings(arg_0)).map(ColumnSettings::getColumnName).toArray(String[]::new);
        return groups;
    }

    @Override
    protected String[][] createGroups() {
        String[][] groups = new String[0][0];
        if (this.isStacked()) {
            groups = this.stackedGroups();
        }
        return groups;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }
}

