/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.map;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.c3.client.C3AbstractDisplayer;
import org.dashbuilder.renderer.c3.client.charts.map.D3MapConf;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.CountriesGeoJsonService;

@Dependent
public class D3MapDisplayer
extends C3AbstractDisplayer<View> {
    View view;
    private boolean markers;
    private boolean regions;
    private CountriesGeoJsonService geoService;
    private D3MapConf conf;

    @Override
    protected void createVisualization() {
        this.getView().setFilterLabelSet(this.filterLabelSet);
        super.createVisualization();
    }

    @Inject
    public D3MapDisplayer(FilterLabelSet filterLabelSet, View view, CountriesGeoJsonService countriesGeoJsonService) {
        super(filterLabelSet);
        view.init((Object)this);
        this.view = view;
        this.geoService = countriesGeoJsonService;
    }

    public View getView() {
        return this.view;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMinColumns(2)).setMaxColumns(3)).setExtraColumnsAllowed(true)).setGroupsTitle(this.getView().getGroupsTitle()).setColumnsTitle(this.getView().getColumnsTitle()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP);
    }

    @Override
    protected void updateVisualizationWithData() {
        Map<String, Double> data = this.retrieveData(this.dataSet);
        String backgroundColor = this.displayerSettings.getChartBackgroundColor();
        String columnName = this.getDataColumnName();
        this.conf = D3MapConf.of(columnName, data, this.markers, this.regions, backgroundColor, this.geoService, this::format, this::selectLocation);
        this.getView().createMap(this.conf);
    }

    private String getDataColumnName() {
        String name = "Data";
        if (this.dataSet.getColumns().size() > 1) {
            DataColumn column = (DataColumn)this.dataSet.getColumns().get(1);
            name = this.displayerSettings.getColumnSettings(column).getColumnName();
        }
        return name;
    }

    protected Map<String, Double> retrieveData(DataSet dataSet) {
        HashMap<String, Double> data = new HashMap<String, Double>();
        List columns = dataSet.getColumns();
        List locations = ((DataColumn)columns.get(0)).getValues();
        List numbers = ((DataColumn)columns.get(1)).getValues();
        int total = locations.size();
        for (int i = 0; i < total; ++i) {
            Object locationValue = locations.get(i);
            Object numberValue = numbers.get(i);
            String numberStr = this.columnValueToString(numberValue);
            String location = this.columnValueToString(locationValue);
            Double value = Double.parseDouble(numberStr);
            data.put(location, value);
        }
        return data;
    }

    public void selectLocation(String location) {
        List columns;
        List locations;
        int rowIndex;
        if (this.displayerSettings.isFilterNotificationEnabled() && (rowIndex = (locations = ((DataColumn)(columns = this.dataSet.getColumns()).get(0)).getValues()).indexOf(location)) != -1) {
            this.addToSelection(rowIndex);
        }
    }

    public String format(Double value) {
        String textValue = value.toString();
        List columns = this.dataSet.getColumns();
        if (columns.size() > 1) {
            textValue = super.formatValue((Object)value, (DataColumn)columns.get(1));
        }
        return textValue;
    }

    public D3MapDisplayer markers() {
        this.markers = true;
        return this;
    }

    public D3MapDisplayer regions() {
        this.regions = true;
        return this;
    }

    public D3MapConf getConf() {
        return this.conf;
    }

    public static interface View
    extends C3AbstractDisplayer.View<D3MapDisplayer> {
        public String getColumnsTitle();

        public String getGroupsTitle();

        public void createMap(D3MapConf var1);
    }
}

