/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.map.geojson.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.CountriesGeoJsonService;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.GeoJsonLoader;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.Feature;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.FeatureCollection;

public class CountriesGeoJsonServiceImpl
implements CountriesGeoJsonService {
    static final String COUNTRY_NAME_PROPERTY = "name";
    @Inject
    GeoJsonLoader geoJsonLoader;
    private FeatureCollection featureCollection;

    @PostConstruct
    public void setup() {
        this.featureCollection = this.geoJsonLoader.load();
    }

    @Override
    public Feature[] getCountries() {
        return this.featureCollection.getFeatures();
    }

    @Override
    public String getCountryName(Feature country) {
        Object name;
        Object object = name = country == null ? null : country.getProperties().get(COUNTRY_NAME_PROPERTY);
        if (name != null) {
            return name.toString();
        }
        return "";
    }

    @Override
    public String getCountryNameByCode(String code) {
        return Arrays.stream(this.featureCollection.getFeatures()).filter(f -> f.getId().equalsIgnoreCase(code)).map(this::getCountryName).findFirst().orElse("");
    }

    @Override
    public Optional<Feature> countryByIdOrName(String idOrName) {
        return Arrays.stream(this.featureCollection.getFeatures()).filter(f -> {
            String countryName = this.getCountryName((Feature)f);
            return idOrName.equalsIgnoreCase(f.getId()) || idOrName.equalsIgnoreCase(countryName);
        }).findFirst();
    }

    @Override
    public Optional<Map.Entry<String, Double>> entryByCountry(Map<String, Double> data, Feature value) {
        if (value == null) {
            return Optional.empty();
        }
        String countryID = value.getId();
        String countryName = this.getCountryName(value);
        return data.entrySet().stream().filter(k -> ((String)k.getKey()).equalsIgnoreCase(countryID) || ((String)k.getKey()).equalsIgnoreCase(countryName)).findFirst();
    }

    @Override
    public Optional<Double> valueByCountry(Map<String, Double> data, Feature value) {
        Optional<Map.Entry<String, Double>> entry = this.entryByCountry(data, value);
        if (entry.isPresent()) {
            Double val = entry.get().getValue();
            return Optional.ofNullable(val);
        }
        return Optional.empty();
    }
}

