/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.meter;

import java.text.ParseException;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.RawDataSet;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.MeterChartSettingsBuilderImpl;
import org.dashbuilder.renderer.c3.client.C3BaseTest;
import org.dashbuilder.renderer.c3.client.charts.meter.C3MeterChartDisplayer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class C3MeterDisplayerTest
extends C3BaseTest {
    private static final String CL1 = "CL1";
    private static final String CL2 = "CL2";
    RawDataSet twoColumnsRawDS = new RawDataSet(new String[]{"CL1", "CL2"}, new Class[]{String.class, String.class}, (String[][])new String[][]{{"VAL1", "1"}, {"VAL2", "2"}});
    RawDataSet oneColumnsRawDS = new RawDataSet(new String[]{"CL1"}, new Class[]{String.class}, (String[][])new String[][]{{"1"}, {"2"}});
    DisplayerSettings meterSettings = ((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)DisplayerSettingsFactory.newMeterChartSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM)).format("", "0.0000")).buildSettings();
    DisplayerSettings meterSettingsOneColumn = ((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)DisplayerSettingsFactory.newMeterChartSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).column("AMOUNT")).format("", "0.0")).buildSettings();

    @Test
    public void c3meterColumnsExtractorsTest() throws ParseException {
        C3MeterChartDisplayer c3MeterChartDisplayer = this.c3MeterChartDisplayer(this.meterSettings);
        c3MeterChartDisplayer.draw();
        DataSet twoColumnDS = this.twoColumnsRawDS.toDataSet();
        DataSet oneColumnDS = this.oneColumnsRawDS.toDataSet();
        DataColumn cl1 = twoColumnDS.getColumnById(CL1);
        DataColumn cl2 = twoColumnDS.getColumnById(CL2);
        String[][] valuesWhenUsingGrouping = c3MeterChartDisplayer.extractGroupingValues(cl1, cl2);
        Assert.assertEquals((long)2L, (long)valuesWhenUsingGrouping.length);
        Assert.assertArrayEquals((Object[])new String[]{"VAL1", "1"}, (Object[])valuesWhenUsingGrouping[0]);
        Assert.assertArrayEquals((Object[])new String[]{"VAL2", "2"}, (Object[])valuesWhenUsingGrouping[1]);
        cl1 = oneColumnDS.getColumnById(CL1);
        Object[] singleColumnValues = c3MeterChartDisplayer.extractSingleColumnValues(cl1);
        Assert.assertEquals((long)3L, (long)singleColumnValues.length);
        Assert.assertArrayEquals((Object[])new String[]{CL1, "1", "2"}, (Object[])singleColumnValues);
    }

    @Test
    public void columnFormatTest() throws ParseException {
        C3MeterChartDisplayer c3MeterChartDisplayer = this.c3MeterChartDisplayer(this.meterSettings);
        c3MeterChartDisplayer.draw();
        Object formattedTooltip = c3MeterChartDisplayer.formatTooltip(Long.valueOf(1L), null, null);
        Assert.assertEquals((Object)"1.0000", (Object)formattedTooltip);
        c3MeterChartDisplayer = this.c3MeterChartDisplayer(this.meterSettingsOneColumn);
        c3MeterChartDisplayer.draw();
        formattedTooltip = c3MeterChartDisplayer.formatTooltip(Long.valueOf(1L), null, null);
        Assert.assertEquals((Object)"1.0", (Object)formattedTooltip);
    }
}

