/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client;

import com.google.gwt.i18n.client.NumberFormat;
import elemental2.core.JsObject;
import java.util.List;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.renderer.c3.client.C3AbstractDisplayer;
import org.dashbuilder.renderer.c3.client.jsbinding.C3AxisInfo;
import org.dashbuilder.renderer.c3.client.jsbinding.C3AxisX;
import org.dashbuilder.renderer.c3.client.jsbinding.C3AxisY;
import org.dashbuilder.renderer.c3.client.jsbinding.C3ChartConf;
import org.dashbuilder.renderer.c3.client.jsbinding.C3ChartData;
import org.dashbuilder.renderer.c3.client.jsbinding.C3ChartSize;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Color;
import org.dashbuilder.renderer.c3.client.jsbinding.C3DataInfo;
import org.dashbuilder.renderer.c3.client.jsbinding.C3JsTypesFactory;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Legend;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Padding;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Point;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Selection;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Tick;

public abstract class C3Displayer<V extends View>
extends C3AbstractDisplayer<V> {
    private static final double DEFAULT_POINT_RADIUS = 2.5;
    protected C3JsTypesFactory factory;
    public static final String[] COLOR_PATTERN = new String[]{"#0088CE", "#CC0000", "#EC7A08", "#3F9C35", "#F0AB00", "#703FEC", "#007A87", "#92D400", "#35CAED", "#00659C", "#A30000", "#B35C00", "#B58100", "#6CA100", "#2D7623", "#005C66", "#008BAD", "#40199A"};

    public C3Displayer(FilterLabelSet filterLabelSet, C3JsTypesFactory builder) {
        super(filterLabelSet);
        this.factory = builder;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(10)).setMinColumns(2)).setExtraColumnsAllowed(true)).setExtraColumnsType(ColumnType.NUMBER)).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP);
    }

    @Override
    protected void updateVisualizationWithData() {
        if (this.displayerSettings.isResizable()) {
            ((View)this.getView()).setResizable(this.displayerSettings.getChartWidth(), this.displayerSettings.getChartHeight());
        }
        C3ChartConf conf = this.buildConfiguration();
        ((View)this.getView()).updateChart(conf);
        this.applyPropertiesToView();
        String[][] tableData = this.getDataTable();
        ((View)this.getView()).setTableData(tableData);
    }

    protected C3ChartConf buildConfiguration() {
        C3AxisInfo axis = this.createAxis();
        C3ChartData data = this.createData();
        C3Point point = this.createPoint();
        C3Padding padding = this.createPadding();
        C3Legend legend = this.factory.c3Legend(this.displayerSettings.isChartShowLegend(), this.getLegendPosition());
        C3Color color = this.createColor();
        C3ChartSize size = this.createSize();
        return this.factory.c3ChartConf(size, data, axis, this.factory.c3Grid(true, true), this.factory.c3Transition(0), point, padding, legend, color);
    }

    protected C3Color createColor() {
        return this.factory.c3Color(COLOR_PATTERN);
    }

    protected C3ChartSize createSize() {
        C3ChartSize size = null;
        if (!this.displayerSettings.isResizable()) {
            size = this.factory.c3ChartSize(this.displayerSettings.getChartWidth(), this.displayerSettings.getChartHeight());
        }
        return size;
    }

    protected C3Padding createPadding() {
        return this.factory.c3Padding(this.displayerSettings.getChartMarginTop(), this.displayerSettings.getChartMarginRight(), this.displayerSettings.getChartMarginBottom(), this.displayerSettings.getChartMarginLeft());
    }

    protected C3Point createPoint() {
        return this.factory.c3Point(d -> 2.5);
    }

    protected C3ChartData createData() {
        String[][] series = this.createSeries();
        String type = ((View)this.getView()).getType();
        String[][] groups = this.createGroups();
        JsObject xs = this.createXs();
        C3Selection selection = this.createSelection();
        C3ChartData c3Data = this.factory.c3ChartData(series, type, groups, xs, selection);
        if (this.displayerSettings.isFilterNotificationEnabled()) {
            c3Data.setOnselected(this::addToSelection);
        }
        return c3Data;
    }

    protected C3Selection createSelection() {
        boolean filterEnabled = this.displayerSettings.isFilterNotificationEnabled();
        return this.factory.c3Selection(filterEnabled, true, false);
    }

    protected JsObject createXs() {
        return null;
    }

    protected String[][] createGroups() {
        return new String[0][0];
    }

    protected C3AxisInfo createAxis() {
        C3AxisX axisX = this.createAxisX();
        C3AxisY axisY = this.createAxisY();
        return this.factory.c3AxisInfo(false, axisX, axisY);
    }

    protected C3AxisX createAxisX() {
        String[] categories = this.createCategories();
        C3Tick tick = this.createTickX();
        return this.factory.c3AxisX("category", categories, tick);
    }

    protected C3Tick createTickX() {
        return this.factory.createC3Tick(null);
    }

    protected C3AxisY createAxisY() {
        C3Tick tickY = this.createTickY();
        return this.factory.c3AxisY(true, tickY);
    }

    protected C3Tick createTickY() {
        return this.factory.createC3Tick(f -> {
            try {
                double doubleFormat = Double.parseDouble(f);
                return NumberFormat.getFormat((String)"#,###.##").format(doubleFormat);
            }
            catch (NumberFormatException e) {
                return f;
            }
        });
    }

    protected String[] createCategories() {
        List columns = this.dataSet.getColumns();
        DataColumn dataColumn = (DataColumn)columns.get(0);
        String[] categories = null;
        if (columns.size() > 0) {
            List values = dataColumn.getValues();
            categories = new String[values.size()];
            for (int i = 0; i < categories.length; ++i) {
                Object val = values.get(i);
                categories[i] = val != null ? super.formatValue(val, dataColumn) : "cat_" + i;
            }
        }
        return categories;
    }

    protected String[][] createSeries() {
        List columns = this.dataSet.getColumns();
        String[][] data = null;
        if (columns.size() > 1) {
            data = new String[columns.size() - 1][];
            for (int i = 1; i < columns.size(); ++i) {
                DataColumn dataColumn = (DataColumn)columns.get(i);
                ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
                List values = dataColumn.getValues();
                String[] seriesValues = new String[values.size() + 1];
                seriesValues[0] = columnSettings.getColumnName();
                for (int j = 0; j < values.size(); ++j) {
                    seriesValues[j + 1] = values.get(j).toString();
                }
                data[i - 1] = seriesValues;
            }
        }
        return data;
    }

    protected int getSelectedRowIndex(C3DataInfo info) {
        return info.getIndex();
    }

    protected String getSelectedCategory(C3DataInfo info) {
        List values = ((DataColumn)this.dataSet.getColumns().get(0)).getValues();
        return values.get(info.getIndex()).toString();
    }

    protected String[][] getDataTable() {
        List columns = this.dataSet.getColumns();
        String[][] data = new String[columns.size()][];
        for (int i = 0; i < columns.size(); ++i) {
            List values = ((DataColumn)columns.get(i)).getValues();
            data[i] = new String[values.size()];
            for (int j = 0; j < values.size(); ++j) {
                data[i][j] = this.columnValueToString(values.get(j));
            }
        }
        return data;
    }

    private void addToSelection(C3DataInfo data) {
        int row = this.getSelectedRowIndex(data);
        this.addToSelection(row);
    }

    private void applyPropertiesToView() {
        if (this.displayerSettings.isTitleVisible()) {
            ((View)this.getView()).showTitle(this.displayerSettings.getTitle());
        }
        ((View)this.getView()).setBackgroundColor(this.displayerSettings.getChartBackgroundColor());
    }

    private String getLegendPosition() {
        Position legendPosition = this.displayerSettings.getChartLegendPosition();
        String c3LegendPosition = C3Legend.convertPosition(legendPosition);
        return c3LegendPosition;
    }

    public static interface View<P extends C3AbstractDisplayer>
    extends C3AbstractDisplayer.View<P> {
        public void updateChart(C3ChartConf var1);

        public String getType();

        public String getGroupsTitle();

        public String getColumnsTitle();

        @Override
        public void showTitle(String var1);

        @Override
        public void setFilterLabelSet(FilterLabelSet var1);

        public void setBackgroundColor(String var1);

        public void setResizable(int var1, int var2);

        public void setTableData(String[][] var1);
    }
}

