/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.map.geojson.impl;

import java.util.HashMap;
import java.util.Optional;
import jsinterop.base.JsPropertyMap;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.GeoJsonLoader;
import org.dashbuilder.renderer.c3.client.charts.map.geojson.impl.CountriesGeoJsonServiceImpl;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.Feature;
import org.dashbuilder.renderer.c3.client.jsbinding.geojson.FeatureCollection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CountriesGeoJsonServiceImplTest {
    private static final String COUNTRY_CODE = "ID";
    private static final String COUNTRY_NAME = "Name";
    @Mock
    GeoJsonLoader geoJsonLoader;
    @Mock
    JsPropertyMap<Object> properties;
    @Mock
    Feature feature;
    @Mock
    FeatureCollection featureCollection;
    @InjectMocks
    CountriesGeoJsonServiceImpl countriesGeoJsonServiceImpl;

    @Before
    public void setup() {
        Mockito.when((Object)this.properties.get("name")).thenReturn((Object)COUNTRY_NAME);
        Mockito.when((Object)this.feature.getProperties()).thenReturn(this.properties);
        Mockito.when((Object)this.feature.getId()).thenReturn((Object)COUNTRY_CODE);
        Mockito.when((Object)this.featureCollection.getFeatures()).thenReturn((Object)new Feature[]{this.feature});
        Mockito.when((Object)this.geoJsonLoader.load()).thenReturn((Object)this.featureCollection);
    }

    @Test
    public void getCountryNameTest() {
        String countryName = this.countriesGeoJsonServiceImpl.getCountryName(this.feature);
        Assert.assertEquals((Object)COUNTRY_NAME, (Object)countryName);
        countryName = this.countriesGeoJsonServiceImpl.getCountryName(null);
        Assert.assertTrue((boolean)countryName.isEmpty());
    }

    @Test
    public void getCountryNameByCodeTest() {
        String countryName = this.countriesGeoJsonServiceImpl.getCountryNameByCode(COUNTRY_CODE);
        Assert.assertEquals((Object)COUNTRY_NAME, (Object)countryName);
        countryName = this.countriesGeoJsonServiceImpl.getCountryNameByCode("123");
        Assert.assertTrue((boolean)countryName.isEmpty());
        countryName = this.countriesGeoJsonServiceImpl.getCountryNameByCode(null);
        Assert.assertTrue((boolean)countryName.isEmpty());
    }

    @Test
    public void countryByIdOrNameTest() {
        Optional countryByIdOrName = this.countriesGeoJsonServiceImpl.countryByIdOrName(COUNTRY_CODE);
        Assert.assertTrue((boolean)countryByIdOrName.isPresent());
        Assert.assertEquals((Object)this.feature, countryByIdOrName.get());
        countryByIdOrName = this.countriesGeoJsonServiceImpl.countryByIdOrName(COUNTRY_NAME);
        Assert.assertTrue((boolean)countryByIdOrName.isPresent());
        Assert.assertEquals((Object)this.feature, countryByIdOrName.get());
        countryByIdOrName = this.countriesGeoJsonServiceImpl.countryByIdOrName("123");
        Assert.assertTrue((!countryByIdOrName.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void entryByCountryTest() {
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put(COUNTRY_NAME, 1.0);
        Optional entryByCountry = this.countriesGeoJsonServiceImpl.entryByCountry(data, this.feature);
        Assert.assertTrue((boolean)entryByCountry.isPresent());
        entryByCountry = this.countriesGeoJsonServiceImpl.entryByCountry(data, null);
        Assert.assertTrue((!entryByCountry.isPresent() ? 1 : 0) != 0);
        entryByCountry = this.countriesGeoJsonServiceImpl.entryByCountry(new HashMap(), this.feature);
        Assert.assertTrue((!entryByCountry.isPresent() ? 1 : 0) != 0);
    }

    public void valueByCountryTest() {
        Double val = 1.0;
        HashMap<String, Double> data = new HashMap<String, Double>();
        data.put(COUNTRY_NAME, val);
        Optional valueByCountry = this.countriesGeoJsonServiceImpl.valueByCountry(data, this.feature);
        Assert.assertTrue((boolean)valueByCountry.isPresent());
        Assert.assertEquals((Object)val, valueByCountry.get());
        valueByCountry = this.countriesGeoJsonServiceImpl.valueByCountry(data, null);
        Assert.assertTrue((!valueByCountry.isPresent() ? 1 : 0) != 0);
        valueByCountry = this.countriesGeoJsonServiceImpl.valueByCountry(new HashMap(), null);
        Assert.assertTrue((!valueByCountry.isPresent() ? 1 : 0) != 0);
    }
}

