/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.map;

import java.text.ParseException;
import java.util.Map;
import org.dashbuilder.dataset.RawDataSet;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.LineChartSettingsBuilderImpl;
import org.dashbuilder.renderer.c3.client.C3BaseTest;
import org.dashbuilder.renderer.c3.client.charts.map.D3MapConf;
import org.dashbuilder.renderer.c3.client.charts.map.D3MapDisplayer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class D3MapDisplayerTest
extends C3BaseTest {
    private static final String COUNTRY_1 = "Country1";
    private static final String COUNTRY_2 = "Country2";
    private static final Integer VAL_1 = 1;
    private static final Integer VAL_2 = 2;
    private static final String CL_TITLE = "Title in Column";
    private static final String BG_COLOR = "red";
    RawDataSet twoColumnsRawDS = new RawDataSet(new String[]{"cl", "cl2"}, new Class[]{String.class, String.class}, (String[][])new String[][]{{"Country1", VAL_1.toString()}, {"Country2", VAL_2.toString()}});
    private D3MapDisplayer displayer;

    @Before
    public void conf() {
        DisplayerSettings noData = ((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)DisplayerSettingsFactory.newLineChartSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM, CL_TITLE)).backgroundColor(BG_COLOR)).buildSettings();
        this.displayer = this.d3MapDisplayer(noData);
        this.displayer.draw();
    }

    @Test
    public void dataRetrievalTest() throws ParseException {
        Map data = this.displayer.retrieveData(this.twoColumnsRawDS.toDataSet());
        Double val1 = (Double)data.get(COUNTRY_1);
        Assert.assertNotNull((Object)val1);
        Assert.assertEquals((long)VAL_1.intValue(), (long)val1.intValue());
    }

    @Test
    public void mapConfTest() throws ParseException {
        this.displayer.updateVisualizationWithData();
        D3MapConf conf = this.displayer.getConf();
        Assert.assertEquals((Object)CL_TITLE, (Object)conf.getTitle());
        Assert.assertEquals((Object)BG_COLOR, (Object)conf.getBackgroundColor());
        ((D3MapDisplayer.View)Mockito.verify((Object)this.displayer.getView())).createMap(conf);
    }
}

