/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.bubble;

import com.google.gwt.core.shared.GWT;
import elemental2.core.JsObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import jsinterop.base.Any;
import jsinterop.base.Js;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.renderer.c3.client.C3Displayer;
import org.dashbuilder.renderer.c3.client.C3XYDisplayer;
import org.dashbuilder.renderer.c3.client.charts.CommonC3DisplayerConstants;
import org.dashbuilder.renderer.c3.client.charts.bubble.BubbleData;
import org.dashbuilder.renderer.c3.client.jsbinding.C3DataInfo;
import org.dashbuilder.renderer.c3.client.jsbinding.C3JsTypesFactory;
import org.dashbuilder.renderer.c3.client.jsbinding.C3Point;

@Dependent
public class C3BubbleChartDisplayer
extends C3XYDisplayer<View> {
    private static final int X_INDEX = 1;
    private static final int Y_INDEX = 2;
    private static final int R_INDEX = 4;
    private static double MIN_BUBBLE_SIZE = 5.0;
    private static double MAX_BUBBLE_SIZE = 45.0;
    private View view;

    @Inject
    public C3BubbleChartDisplayer(View view, FilterLabelSet filterLabelSet, C3JsTypesFactory factory) {
        super(filterLabelSet, factory);
        this.view = view;
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    @Override
    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(5)).setMinColumns(5)).setExtraColumnsAllowed(false)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle()).setColumnTitle(Integer.valueOf(1), "X").setColumnTitle(Integer.valueOf(2), "Y").setColumnTitle(Integer.valueOf(3), "Bubble Size").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER, ColumnType.NUMBER, ColumnType.LABEL, ColumnType.NUMBER}});
        return new CommonC3DisplayerConstants(lookupConstraints).create().supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP);
    }

    @Override
    protected String[][] createSeries() {
        int i;
        List columns = this.dataSet.getColumns();
        String[] categories = this.createCategories();
        String[][] data = new String[categories.length * 2][];
        ArrayList<BubbleData> bubbleData = new ArrayList<BubbleData>();
        for (i = 0; i < categories.length; ++i) {
            String x = ((DataColumn)columns.get(1)).getValues().get(i).toString();
            String y = ((DataColumn)columns.get(2)).getValues().get(i).toString();
            bubbleData.add(new BubbleData(Double.valueOf(x), Double.valueOf(y), categories[i]));
        }
        Collections.sort(bubbleData, Comparator.comparingDouble(BubbleData::getX));
        int y = 0;
        for (i = 0; i < bubbleData.size(); ++i) {
            BubbleData bData = (BubbleData)bubbleData.get(i);
            String catY = bData.getCategory();
            String catX = bData.getCategory() + "_x";
            Double xVal = bData.getX();
            Double yVal = bData.getY();
            data[y] = new String[]{catX, xVal.toString()};
            data[y + 1] = new String[]{catY, yVal.toString()};
            y += 2;
        }
        return data;
    }

    @Override
    protected JsObject createXs() {
        String[] categories;
        JsObject xs = JsObject.create(null);
        for (String category : categories = this.createCategories()) {
            ((Any)Js.cast((Object)xs)).asPropertyMap().set(category, (Object)(category + "_x"));
        }
        return xs;
    }

    @Override
    protected C3Point createPoint() {
        List columns = this.dataSet.getColumns();
        String[] categories = this.createCategories();
        int n = categories.length;
        HashMap<String, Double> rValues = new HashMap<String, Double>();
        ArrayList<Double> valuesBeforeMap = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            String valueStr = ((DataColumn)columns.get(4)).getValues().get(i).toString();
            try {
                valuesBeforeMap.add(Double.parseDouble(valueStr));
                continue;
            }
            catch (NumberFormatException e) {
                GWT.log((String)"Not able to retrieve radius values. Exiting radius calculation.", (Throwable)e);
                return super.createPoint();
            }
        }
        double min = (Double)Collections.min(valuesBeforeMap);
        double max = (Double)Collections.max(valuesBeforeMap);
        for (int i = 0; i < n; ++i) {
            String cat = categories[i];
            double r = min == max ? (MAX_BUBBLE_SIZE + MIN_BUBBLE_SIZE) / 2.0 : this.map((Double)valuesBeforeMap.get(i), min, max, MIN_BUBBLE_SIZE, MAX_BUBBLE_SIZE);
            rValues.put(cat, r);
        }
        return this.factory.c3Point(d -> (Double)rValues.get(d.getId()));
    }

    @Override
    protected String getSelectedCategory(C3DataInfo info) {
        return info.getName();
    }

    @Override
    protected int getSelectedRowIndex(C3DataInfo info) {
        String[] categories = this.createCategories();
        return Arrays.asList(categories).indexOf(info.getName());
    }

    private double map(double value, double start1, double stop1, double start2, double stop2) {
        return start2 + (stop2 - start2) * ((value - start1) / (stop1 - start1));
    }

    public static interface View
    extends C3Displayer.View<C3BubbleChartDisplayer> {
    }
}

