/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.c3.client.charts.map.widgets;

import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.Optional;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.views.pfly.widgets.D3;

@Templated
@ApplicationScoped
public class MapTooltip
implements IsElement {
    @Inject
    @DataField
    HTMLDivElement mapTooltipContainer;
    @Inject
    @DataField
    @Named(value="strong")
    HTMLElement lblTooltipTitle;
    @Inject
    @DataField
    @Named(value="span")
    HTMLElement lblTooltipCategory;
    @Inject
    @DataField
    @Named(value="strong")
    HTMLElement lblTooltipValue;
    private D3 d3 = D3.Builder.get();

    public HTMLElement getElement() {
        return this.mapTooltipContainer;
    }

    public void show(String title, String category, Optional<Double> data, Function<Double, String> formatter) {
        this.d3.select((Object)this.mapTooltipContainer).transition().duration(400.0).style("opacity", (Object)"0.9");
        this.lblTooltipTitle.textContent = title;
        if (data.isPresent()) {
            this.lblTooltipValue.style.visibility = "visible";
            this.lblTooltipCategory.textContent = category + ": ";
            this.lblTooltipValue.textContent = formatter.apply(data.get());
        } else {
            this.lblTooltipCategory.textContent = "No data.";
            this.lblTooltipValue.style.visibility = "hidden";
        }
    }

    public void hide() {
        this.d3.select((Object)this.mapTooltipContainer).transition().duration(500.0).style("opacity", (Object)"0");
    }

    public void move() {
        int x = this.d3.getEvent().getPageX() + 10;
        int y = this.d3.getEvent().getPageY() - 40;
        this.d3.select((Object)this.mapTooltipContainer).style("left", (Object)(x + "px")).style("top", (Object)(y + "px"));
    }
}

